<?php

include_once CLASSES.'class_pages.php';
include_once CLASSES.'class_block.php';
include_once CLASSES.'class_forum.php';

// Überprüfen ob die Board-Tabelle existiert
if (!Settings::is_GaestebuchActivated()) {
	Message::$errorType = 'gae_noGaestebuch';
	refresh(MAIN);
} else {
	
	if (!isset($_GET['action'])) $_GET['action'] = 'index';
	$tpl->assign('_ACTION', $_GET['action']);
	define('THIS', MAIN.'?section=gaestebuch');
	$tpl->assign('THIS', THIS);
	
	if (!isset($_GET['PostID'])) $_GET['PostID'] = 0;
	$PostID = addslashes($_GET['PostID']);
	$PostID_check = MySQL::single("SELECT COUNT(*) FROM ".ABK."_gaestebuch WHERE PostID = '".$PostID."'");
	if (!$PostID_check) $PostID = 0;
	$tpl->assign('_POSTID', $PostID);
	$tpl->assign('LOCK_FOR_UNDECLARED', Settings::get(ABK, 'GaestebuchLockForUndeclared'));
	
	$pages = new Pages(10);
	
}

if (Message::noError()) { 
	// Standard - Display setzen
	$cache->noCache('content', 'all_gaestebuch.tpl');
	
	switch ($_GET['action']) {
	///////////////////////////////////////////////////////////////////////////////////////////////////
		case 'index': {
			if ($cache->isCached('content', 'all_gaestebuch.tpl', 
				ABK.'|index|'.(isset($_GET['page']) ? $_GET['page'] : 0), secondsToMidnight()))
				break;
			$sql_limitless = "SELECT * FROM ".ABK."_gaestebuch ORDER BY Time DESC ";
			if ($PostID_check) {
				$pages->getPage_Gaestebuch($PostID);
			}
			$beitraege = MySQL::assocs($sql_limitless.$pages->limit());
			//Ausgabe
			$beitraege_output = array();
			if (count($beitraege)) {
				Forum::thema_config("Autor", "Beitrag", "150px");
				foreach($beitraege as $vl) {
					$temp = Forum::beitrag_anzeigen_spezific($vl['PostID'], $vl['AutorID'], $vl['Autor'], $vl['Inhalt'], $vl['Time']);
					$temp = Forum::beitrag_interaktion($temp, 0, 0);
					array_push($beitraege_output, $temp);
				}
				if (DECLARED || !Settings::get(ABK, 'GaestebuchLockForUndeclared'))
					Forum::thema_interaktionen_aktivieren();
			}
			$pages->ausgabe(THIS, $sql_limitless);
			Forum::thema_assign($beitraege_output);
			break;
	    }
	///////////////////////////////////////////////////////////////////////////////////////////////////
		case 'all': {
			if (!DECLARED) {
				Message::$errorType = 'gae_only_declared';
				refresh(THIS);
			} else {
				if ($cache->isCached('content', 'all_gaestebuch.tpl', ABK.'|index', secondsToMidnight()))
					break;
				$sql_limitless = "SELECT * FROM ".ABK."_gaestebuch ORDER BY Time ASC ";
				$beitraege = MySQL::assocs($sql_limitless); 
				//Ausgabe
				$beitraege_output = array();
				if (count($beitraege)) {
					Forum::thema_config("Autor", "Beitrag", "100px");
					foreach($beitraege as $vl) {
						$temp = Forum::beitrag_anzeigen_spezific($vl['PostID'], $vl['AutorID'], $vl['Autor'], $vl['Inhalt'], $vl['Time']);
						array_push($beitraege_output, $temp);
					}
				}
				Forum::thema_assign($beitraege_output);
			}
			break;
	    }
	///////////////////////////////////////////////////////////////////////////////////////////////////
		case 'Beitrag_eintragen': {
			if (!DECLARED && Settings::get(ABK, 'GaestebuchLockForUndeclared')) {
				Message::$errorType = 'gae_block_undeclared';
				refresh(THIS);
				break;
			}
			if (!DECLARED && Block::tempBlockCheck()) {
				Message::$errorType = 'gae_blocked_user';
				refresh(THIS);
				break;
			}
			$text = "";
			if ($PostID_check && isset($_GET['quote'])) {
				$quote = MySQL::assoc("SELECT Autor, AutorID, Inhalt FROM ".ABK."_gaestebuch WHERE PostID = '".$PostID."'");
				$text = "[quote]Zitat von: ".$quote['Autor']."\n".$BBC->ausgabe($quote['Inhalt'], false)."[/quote]";
	        }
	        if (!$PostID_check && isset($_GET['quote'])) {
	        	Message::$errorType = 'gae_entry_quoted_notExists';
	        	refresh(THIS);
	        	break;
	        }
			$tpl->assign('QUOTE_TEXT', $text);
			$beitraege = MySQL::assocs("SELECT * FROM ".ABK."_gaestebuch ORDER BY Time DESC LIMIT 1");
			//Ausgabe
			$beitraege_output = array();
			if (count($beitraege)) {
				Forum::thema_config("Autor", "Beitrag", "100px");
				foreach($beitraege as $vl) {
	      			$temp = Forum::beitrag_anzeigen_spezific($vl['PostID'], $vl['AutorID'], $vl['Autor'], $vl['Inhalt'], $vl['Time']);
	      			array_push($beitraege_output, $temp);
				}
			}
			Forum::thema_assign($beitraege_output);
			Block::timeBlockSet('gaestebuch');
			break;
	    }
	///////////////////////////////////////////////////////////////////////////////////////////////////
		case 'beitrag_indb': {
			if ('POST' != $_SERVER['REQUEST_METHOD'])
				Message::$errorType = 'unvalidRequest';
			elseif (!isset($_POST['Beitrag']))
				Message::$errorType = 'unvalidForm';
			elseif ('' == $beitrag = trim($_POST['Beitrag']))
				Message::$errorType = 'unfilledForm';
			elseif ((!DECLARED) && 
					((Block::timeBlockCheck('gaestebuch')) ||
					 (Block::captchaCheck()) ||
					 (!isset($_POST['EMail'], $_POST['Name'])) ||
					 ($_POST['EMail'] != '') || ($_POST['Name'] != '')))
				Message::$errorType = 'gae_spamBlock';
			else {
				// Autor
				if (DECLARED) {
					$autor = NICK;
				} else {
					if (!isset($_POST['Autor']))
						Message::$errorType = 'unvalidForm';
					elseif (('' == $autor = trim($_POST['Autor'])))
						Message::$errorType = 'unfilledForm';
					elseif (Block::tempBlockCheck()) 
						Message::$errorType = 'gae_blocked_user';
					elseif (Settings::get(ABK, 'GaestebuchLockForUndeclared'))
						Message::$errorType = 'gae_block_undeclared';
					else {
						$autor = BBC::validate('nick', $autor, 'gae');
					}
				}
				
				// Beitrag
				$beitrag = BBC::validate('BBC', $beitrag);
				if (Message::noError()) {
					if (!DECLARED) Block::tempBlockSet(30*MIN);
					$cache->clearCache('all_gaestebuch.tpl', ABK.'|index');
					MySQL::insert("INSERT INTO ".ABK."_gaestebuch(Autor, AutorID, Time, Inhalt) ".
						"VALUES ('".$autor."', '".NICKID."', '".TIME."', '".$beitrag."')");
					Message::$successType = 'gae_entry_new';
					refresh(THIS);
					break;
				}
			} // Auf leeren Inhalt checken -> Ende
			refresh(THIS);
			break;
	    }
	///////////////////////////////////////////////////////////////////////////////////////////////////
		case 'edit': {
			$idcheck = MySQL::single("SELECT COUNT(*) FROM ".ABK."_gaestebuch WHERE (PostID = '".$PostID."' AND AutorID = '".NICKID."')");
			if (DECLARED && $idcheck) {
				$old = MySQL::single("SELECT Inhalt FROM ".ABK."_gaestebuch WHERE PostID = '".$PostID."'");
				$tpl->assign('INHALT', $BBC->ausgabe($old, false));
				break;
			}
			Message::$errorType = 'gae_author_notDeclared_OR_idUnvalid';
			refresh(THIS);
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////
		case 'edit_indb': {
			if ($_SERVER['REQUEST_METHOD'] != "POST")
				Message::$errorType = 'unvalidRequest';
			elseif (!DECLARED || 
				!MySQL::single("SELECT COUNT(*) FROM ".ABK."_gaestebuch 
					WHERE (PostID = '".$PostID."' AND AutorID = '".NICKID."')"))
				Message::$errorType = 'gae_author_notDeclared_OR_idUnvalid';
			elseif (!isset($_POST['Beitrag']) || ('' == $beitrag = trim($_POST['Beitrag'])))
				Message::$errorType = 'unfilledForm';
			else {
				$pages->getPage_Gaestebuch($PostID);
				$beitrag = BBC::validate('BBC', $beitrag."\n\n".
					$message->info('gae_entry_editMark', array('[nick]' => NICK, '[date]' => date('d. M Y H:i',TIME))));
				if (Message::noError()) {
					$cache->clearCache('all_gaestebuch.tpl', ABK.'|index');
					MySQL::query("UPDATE ".ABK."_gaestebuch SET Inhalt = '".$beitrag."' WHERE PostID = '".$PostID."'");
					Message::$successType = 'gae_entry_edit';
					refresh(THIS.'&amp;page='.$pages->getPage());
					break;
				}
			}
			refresh(THIS.'&amp;page='.$pages->getPage());
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////
		case 'delete': {
			$idcheck = MySQL::single("SELECT COUNT(*) FROM ".ABK."_gaestebuch WHERE 
				(PostID = '".$PostID."' AND 
				AutorID = '".NICKID."' AND 
				Time > '".(TIME-(DAY/2))."')");
			$pages->getPage_Gaestebuch($PostID);
			if (DECLARED && $idcheck) {
				$cache->clearCache('all_gaestebuch.tpl', ABK.'|index');
				MySQL::query("DELETE FROM ".ABK."_gaestebuch WHERE PostID = '".$PostID."'");
				Message::$successType = 'gae_entry_del';
				refresh(THIS.'&amp;page='.$pages->getPage());
				break;
			}
			Message::$errorType = 'gae_entry_del_noPermisson';
			refresh(THIS.'&amp;page='.$pages->getPage());
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////
	}

} // error
?>