<?php

include_once CLASSES.'class_mail.php';
include_once CLASSES.'class_termin.php';
include_once CLASSES.'class_pages.php';
include_once CLASSES.'class_forum.php';

// Überprüfen ob die Board-Tabelle existiert
if (!Settings::is_ForumActivated(GENERAL_ABK)) {
	Message::$errorType = 'board_noBoard';
	refresh(MAIN);
} else {
	
	// Action überprüfen
	if (!isset($_GET['action'])) $_GET['action'] = 'index';
	$tpl->assign('_ACTION', $_GET['action']);
	define('THIS', MAIN.'?section=forum'.(GENERAL_MOD ? '&amp;general_mod=1' : ''));
	$tpl->assign('THIS', THIS);
	
	$forum = new Forum(GENERAL_ABK); // Prüft PostID, ThreadID, BoardID
	$tpl->assign('_POSTID', $forum->PostID);
	$tpl->assign('_THREADID', $forum->ThreadID);
	$tpl->assign('_BOARDID', $forum->BoardID);
	
	if ($forum->validateBoardID()) {
		$tpl->assign('CURRENT_BOARDNAME', $BBC->ausgabe(
			MySQL::single("SELECT Name From ".GENERAL_ABK."_forum_board WHERE BoardID = '".$forum->BoardID."'")), false);
	}	
	$pages = new Pages(10);
}

if (Message::noError()) {
	// Display setzen
	$cache->noCache('content', 'all_forum.tpl');
	
	switch ($_GET['action']) {
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'index': {
			$boards = MySQL::assocs("SELECT * FROM ".GENERAL_ABK."_forum_board ORDER BY OrderID");
			$boards_output = array();
			if (count($boards)) {
				foreach($boards as $vl) {
					$vl['Name'] = $BBC->ausgabe($vl['Name'], false);
					$vl['Description'] = $BBC->ausgabe($vl['Description'], false);
					$temp = MySQL::assoc("SELECT * FROM ".GENERAL_ABK."_forum_post WHERE PostID = '".$vl['LastPostID']."'");
					$vl['LastPost'] = $temp;
					array_push($boards_output, $vl);
				}
			}
			$tpl->assign('FOREN', $boards_output);
			break;	
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'Themen': {
			if ($forum->validateBoardID()) {
				$sql_limitless = "SELECT t.* FROM ".GENERAL_ABK."_forum_thread AS t
						WHERE t.BoardID = '".$forum->BoardID."' ORDER BY t.LastPostID DESC ";
				$thread = MySQL::assocs($sql_limitless.$pages->limit());
				$thread_output = array();
				if (count($thread)) {
					$pages->ausgabe(THIS.'&amp;action=Themen&amp;BoardID='.$forum->BoardID, $sql_limitless, 4);
					foreach($thread as $vl) {
						$vl['Thema'] = $BBC->ausgabe($vl['Thema'], false);
						$vl['Anzahl_Posts'] = $vl['Posts'];
						if ($vl['Anzahl_Posts']) {
							$temp = MySQL::assoc("SELECT * FROM ".GENERAL_ABK."_forum_post WHERE PostID = '".$vl['LastPostID']."'");
							$vl['Beitrag'] = $temp;
						}
						else {
							$vl['Beitrag'] = array();
						}
						array_push($thread_output, $vl);
					}
				}
				$tpl->assign('THREAD', $thread_output);
				break;
			}
			Message::$errorType = 'board_BoardID_unvalid';
			refresh(THIS);
	    	break;
	    }
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'neue_Beitraege': {
			$sql = "";
			$new_posts = MySQL::assocs("SELECT p.PostID, p.ThreadID, p.Autor, p.AutorID, p.Time, p.Inhalt, 
				t.Thema, t.BoardID, b.Name AS BoardName  
				FROM ".GENERAL_ABK."_forum_post AS p 
					JOIN ".GENERAL_ABK."_forum_thread AS t ON (t.ThreadID = p.ThreadID)
					JOIN ".GENERAL_ABK."_forum_board AS b ON (b.BoardID = t.BoardID)
				ORDER BY Time DESC ".$pages->limit());
			$new_posts_output = array();
			if (count($new_posts)) {
				foreach($new_posts as $vl) {
					$vl['o_markiert'] = ((TIME - DAY*2) < $vl['Time']);
					$vl['Thema'] = $BBC->ausgabe($vl['Thema'], false);
					array_push($new_posts_output, $vl);
				}
			}
			$tpl->assign('NEW_POSTS', $new_posts_output);
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'Thema': {
			if ($forum->validateThreadID()) {
				$threadtitle = MySQL::single("SELECT Thema FROM ".GENERAL_ABK."_forum_thread WHERE ThreadID = '".$forum->ThreadID."'");
				$tpl->assign('THEMENTITEL', $BBC->ausgabe($threadtitle, false));
				if ($forum->validatePostID()) {
					$_GET['page'] = $pages->getPage_Threads($forum->ThreadID, $forum->PostID);
				}
				$sql_limitless = "SELECT p.PostID, p.ThreadID, p.Autor, p.AutorID, p.Time, p.Inhalt 
						".(!GENERAL_MOD && Settings::is_profilActivated() ? ", a.ForumPostCounter" : "")." 
					FROM ".GENERAL_ABK."_forum_post AS p
						".(!GENERAL_MOD && Settings::is_profilActivated() ? "JOIN ".ABK."_account AS a 
							ON (a.ID = p.AutorID)" : "")."
					WHERE p.ThreadID = '".$forum->ThreadID."' ORDER BY Time ";
				$posts = MySQL::assocs($sql_limitless.$pages->limit());	
				$posts_output = array();
				Forum::thema_config("Autor", "Beitrag", "150px");
				if (count($posts)) {
					Forum::thema_interaktionen_aktivieren();
					$getABK_cache = array(); 
					$pages->ausgabe(THIS.'&amp;action=Thema&amp;ThreadID='.$forum->ThreadID, $sql_limitless);
					foreach($posts as $vl) {
						$temp = Forum::beitrag_anzeigen($vl);
						if (!Settings::is_profilActivated()) $temp['ForumPostCounter'] = 0;
						$temp['AutorAbk'] = getABK($vl['AutorID']);
						$temp['AutorAbk_count'] = count($temp['AutorAbk']);
						$temp = Forum::beitrag_interaktion($temp, $forum->BoardID, $forum->ThreadID);
						array_push($posts_output, $temp);
					}
				}
				Forum::thema_assign($posts_output);
				break;
			}
			Message::$errorType = 'board_ThreadID_unvalid';
			refresh(THIS.'&amp;action=Themen&amp;BoardID='.$forum->BoardID);
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    case 'Thema_eintragen': {
	    	if ($forum->validateBoardID()) {
	    		if (!GENERAL_MOD && $forum->is_Termin() && $forum->termin->getDiskussionStartPermission()) {
	    			$termin = &$forum->termin;
	    			$tpl->assign('QUOTE_THEMA', $BBC->ausgabe($termin->get('Titel'), false)." am ".date('d. M Y',$termin->get('Datum'))); 
	    			$tpl->assign('QUOTE_TEXT', 
	    				$message->info('board_thread_quoteTermin', array('[main]' => MAIN, '[Datum]' => $termin->get('Datum'), 
	    					'[Titel]' => $BBC->ausgabe($termin->get('Titel'), false), 
	    					'[Beschreibung]' => $BBC->ausgabe($termin->get('Beschreibung'), false))));
	    			$tpl->assign('_TERMINID', $termin->get('TerminID'));
	    		}
	    		else {
		    		$tpl->assign('QUOTE_THEMA', '');
	    			$tpl->assign('QUOTE_TEXT', '');
	    			$tpl->assign('_TERMINID', 0);
	    		} 
				break;
	    	}
	    	else {
	    		Message::$errorType = 'board_BoardID_unvalid';
	    		refresh(THIS);
	    	}
	    }
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'thema_indb': {
			if ('POST' != $_SERVER['REQUEST_METHOD'])
				Message::$errorType = 'unvalidRequest';
			elseif (!isset($_POST['Thema'], $_POST['Beitrag']) or
				!$forum->validateBoardID())
				Message::$errorType = 'unvalidForm';
			elseif (('' == $thema = trim($_POST['Thema'])) or 
					('' == $beitrag = trim($_POST['Beitrag'])) ) 
				Message::$errorType = 'unfilledForm';
			else {
				$forum->addThread($thema, $beitrag);
				if (Message::noError()) {
					Message::$successType = 'board_thread_new';
					refresh(THIS.'&amp;action=Thema&amp;ThreadID='.$forum->ThreadID);
					if (!GENERAL_MOD) {
						if ($forum->is_Termin())
							Mail::email_verschicken_alle('newTerminDiskussion', 
								array('[nick]' => NICK, '[thema]' => $BBC->ausgabe($thema, false)));
						else Mail::email_verschicken_alle('newThread', 
							array('[nick]' => NICK, '[thema]' => $BBC->ausgabe($thema, false)));
					}
					break;
				}
			}
			refresh(THIS.'&amp;action=Themen&amp;BoardID='.$forum->BoardID);
			break;
		}	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	    case 'Beitrag_eintragen': {
	    	if ($forum->validateThreadID()) {
	      		$threadtitle = MySQL::single("SELECT Thema FROM ".GENERAL_ABK."_forum_thread WHERE ThreadID = '".$forum->ThreadID."'");
	      		$tpl->assign('THEMENTITEL', $BBC->ausgabe($threadtitle, false));
				$text = "";
				if ($forum->validatePostID() && (isset($_GET['quote']))) {
					$quote = MySQL::assoc("SELECT Autor, AutorID, Inhalt FROM ".GENERAL_ABK."_forum_post 
						WHERE PostID = '".$forum->PostID."'");
					$quote['Inhalt'] = $BBC->ausgabe($quote['Inhalt'], false);
					$text = $message->info('board_post_quote', 
						array('[main]' => MAIN, '[AutorID]' => $quote['AutorID'], 
							'[Autor]' => $quote['Autor'], '[Inhalt]' => $quote['Inhalt']));
				}
				$tpl->assign('QUOTE_TEXT', $text);
				$beitraege = MySQL::assocs("SELECT * FROM ".GENERAL_ABK."_forum_post 
					WHERE ThreadID = '".$forum->ThreadID."' ORDER BY Time DESC LIMIT 2");
				$beitraege_output = array();
				Forum::thema_config("Autor", "Letzte Beitr&auml;ge", "50px");
				if (count($beitraege)) {
					foreach($beitraege as $vl) {
						$temp = Forum::beitrag_anzeigen_spezific($vl['PostID'], $vl['AutorID'], $vl['Autor'], $vl['Inhalt'], $vl['Time']);
						array_push($beitraege_output, $temp);
					}
				}
				Forum::thema_assign($beitraege_output);
				break;
			}
			Message::$errorType = 'board_ThreadID_unvalid';
			refresh(THIS.'&amp;action=Themen&amp;BoardID='.$forum->BoardID);
			break;
	    }
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'beitrag_indb': {
			if ('POST' != $_SERVER['REQUEST_METHOD'])
				Message::$errorType = 'unvalidRequest';
			elseif (!isset($_POST['ThreadID'], $_POST['Beitrag'])) 
				Message::$errorType = 'unvalidForm';
			elseif ('' == $beitrag = trim($_POST['Beitrag']))
				Message::$errorType = 'unfilledForm';
			elseif (!$forum->validateThreadID())
				Message::$errorType = 'board_ThreadID_unvalid';
			else {
				$forum->addPost($beitrag);
				if (Message::noError()) {
					Message::$successType = 'board_post_new';
					refresh(THIS.'&amp;action=Thema&amp;PostID='.$forum->PostID.'#post');
					if (!GENERAL_MOD) Mail::email_verschicken_alle('newPost', array('[nick]' => NICK));
					break;
				}
			}
			refresh(THIS.'&amp;action=Thema&amp;ThreadID='.$forum->ThreadID);
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'edit': {
			if ($forum->validateEditPermission()) {
				$old = MySQL::assoc("SELECT * FROM ".GENERAL_ABK."_forum_post WHERE PostID = '".$forum->PostID."'");
				$tpl->assign('OLD_INHALT', $BBC->ausgabe($old['Inhalt'], false));
				$threadtitle = MySQL::single("SELECT Thema FROM ".GENERAL_ABK."_forum_thread WHERE ThreadID = '".$forum->ThreadID."'");
				$tpl->assign('THEMENTITEL', $BBC->ausgabe($threadtitle, false));
				// Orginal ausgeben
				$beitraege_output = array();
				Forum::thema_config("Autor", "Orginalbeitrag", "50px");
				$beitraege_output[] = Forum::beitrag_anzeigen_spezific($old['PostID'], 
					$old['AutorID'], $old['Autor'], $old['Inhalt'], $old['Time']);
				Forum::thema_assign($beitraege_output);
				break;
			}
			if ($forum->validatePostID()) {
				Message::$errorType = 'board_post_edit_noPermission';
				refresh(THIS.'&amp;action=Thema&amp;PostID='.$forum->PostID.'#post');
			}
			else {
				Message::$errorType = 'board_PostID_unvalid';
				refresh(THIS.'&amp;action=Themen&amp;BoardID='.$forum->BoardID);
			}
			break;	
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'edit_indb': {
			if (!$forum->validateEditPermission()) 
				Message::$errorType = 'board_post_edit_noPermission';
			elseif ('POST' != $_SERVER['REQUEST_METHOD'])
				Message::$errorType = 'unvalidRequest';
			elseif (!isset( $_POST['Beitrag'])) 
				Message::$errorType = 'unvalidForm';
			elseif ('' == $beitrag = trim($_POST['Beitrag']))
				Message::$errorType = 'unfilledForm';
			else {
				$forum->editPost($beitrag);
				if (Message::noError()) {
					Message::$successType = 'board_post_edit';
					refresh(THIS.'&amp;action=Thema&amp;PostID='.$forum->PostID.'#post');
					break;
				}
			}
			if ($forum->validatePostID()) {
				refresh(THIS.'&amp;action=Thema&amp;PostID='.$forum->PostID.'#post');
			} else {
				Message::$errorType = 'board_PostID_unvalid';
				refresh(THIS);
			}
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		case 'delete': {	
			if (!$forum->validatePostID())
				Message::$errorType = 'board_PostID_unvalid';
			elseif (!$forum->validateDelPermission())
				Message::$errorType = 'board_post_del_noPermission';
			else {
				$forum->delPost();
				if ($forum->validatePostID()) {
					Message::$successType = 'board_post_del';
					refresh(THIS.'&amp;action=Thema&amp;PostID='.$forum->PostID.'#post');
				} else {
					Message::$successType = 'board_post_del_lastPost';
					refresh(THIS.'&amp;action=Themen&amp;BoardID='.$forum->BoardID);
				}
				break;
			}
			if ($forum->validatePostID()) {
				refresh(THIS.'&amp;action=Thema&amp;PostID='.$forum->PostID.'#post');
			} else {
				refresh(THIS);
			}
			break;
		}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	}
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//// Seitenfunktionen
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function getABK($AutorID) {
	if (GENERAL_MOD) {
		global $getABK_cache;
		if (isset($getABK_cache[$AutorID])) return $getABK_cache[$AutorID];
		else {
			$getABK_cache[$AutorID] = 
				MySQL::singles("SELECT p.abk 
					FROM general_users_pages AS p 
					JOIN general_settings AS s ON (s.abk = p.abk)
					WHERE p.ID = '".$AutorID."' AND s.showAll = '1'");
			return $getABK_cache[$AutorID];
		}
	}
	else return array(); 
}

?>