<?php

// Überprüfen ob die richtige Anmeldefunktion verwendet wurde
onlyAdmin();

include_once CLASSES.'class_admin.php';
include_once CLASSES.'class_forum.php';
include_once CLASSES.'class_setup.php';

// Action überprüfen
if (!isset($_GET['action'])) $_GET['action'] = 'editSetting';
define('THIS', MAIN.'?section=settings');
$tpl->assign('THIS', THIS);

if ((!Admin::isAdmin()) && 
	($_GET['action'] != 'newPage_indb')) $_GET['action'] = 'newPage';
$tpl->assign('_ACTION', $_GET['action']);

// Generiert die 4 Navigation zur Seitenwahl
Admin::nav4('settings');
// Überprüfen ob man für die übergebene Seite auch Rechte hat
if ($_GET['action'] != 'newPage_indb') {
	$edit_abk = Admin::checkABK('settings');
}
$tpl->assign('MAIN_ADMIN', Admin::isMainAdmin()); // Auf MAIN_ADMIN-RECHTE prüfen

switch ($_GET['action']) {
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'newPage': {
		$pages = MySQL::assocs("SELECT gset.ID, adm.abk, gset.title, gset.FounderID 
			FROM admin_rights AS adm 
				JOIN general_settings AS gset ON (gset.abk = adm.abk) 
			WHERE adm.AdminID = ".NICKID, 'abk');
		$tpl->assign('PAGES', $pages);
		$tpl->assign('USED_SEITE', MySQL::assocs("SELECT ID, abk FROM general_settings"));
		$tpl->assign('MAXNEWPAGES', (Admin::isMainAdmin() ? 1000 : MAXNEWPAGES));
		$cache->noCache('content', 'admin/adm_settings_Homepage.tpl');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'newPage_indb': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['seite'], $_POST['title'])) 
			Message::$errorType = 'unvalidForm';
		elseif (('' == $title = trim($_POST['title'])) or 
				('' == $seite = trim($_POST['seite'])))
			Message::$errorType = 'unfilledForm';
		else {
			$seite = Admin::validate('abk_create', $seite, 'set');
			$title = Admin::validate('title', $title, 'set_hp');
			
			// Überprüfen man noch eine Seite erstellen darf
			if (!Admin::isMainAdmin() && (MAXNEWPAGES <= count(Admin::getPages('settings'))))
				Message::$errorType = 'set_abk_noMorePagesAllowed';
			
			if (Message::noError()) {
				MySQL::insert("INSERT INTO general_settings (abk, title, FounderID)
					VALUES ('".$seite."', '".$title."', '".NICKID."')");
				MySQL::insert("INSERT INTO admin_rights (AdminID, abk) VALUES ('".NICKID."', '".$seite."')");
				
				Setup::generateNewPageFile($seite);
				
				Message::$successType = 'set_homepage_create';
				refresh(THIS.'&amp;action=editSetting&amp;abk='.$seite);
				break;
			}
		}
		refresh(THIS.'&amp;action=newPage');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'delHomepage': {
		if (!isset($_GET['abk'], $_GET['id']))
			Message::$errorType = 'unvalidForm';
		elseif (('' == $abk = trim($_GET['abk'])) OR
				('' == $id = trim($_GET['id'])) OR 
				(!Admin::isFounder($abk)))
			Message::$errorType = 'unvalidForm';
		elseif (!MySQL::single("SELECT COUNT(*) FROM general_settings
			WHERE abk = '".addslashes($abk)."' AND ID = '".addslashes($id)."'"))
			Message::$errorType = 'unvalidForm3';
		elseif (($abk == 'general') || ($abk == 'admin') || ($abk == 'index'))
			Message::$errorType = 'set_abk_noPermissionToDeletePage';
		else {
			$tpl->assign('_ABK', $abk);
			$pages = Admin::getPages();
			$tpl->assign('_TITLE', $pages[$abk]['title']);
			$tpl->assign('_ID', $id);
			$cache->noCache('content', 'admin/adm_settings_Homepage.tpl');
			break;
		}
		refresh(THIS);
		break;
	}	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'finallyDeleteHomepage': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif ((!isset($_POST['abk'], $_POST['id'], $_POST['pw1'], $_POST['pw2'])) or
				(!Admin::isFounder($_POST['abk']))) 
			Message::$errorType = 'unvalidForm';
		elseif (('' == trim($_POST['abk'])) or
				('' == $id = trim($_POST['id'])) or
				('' == $pw1 = trim($_POST['pw1'])) or 
				('' == $pw2 = trim($_POST['pw2'])))
			Message::$errorType = 'unfilledForm';
		else {
			$abk = Admin::validate('abk', $edit_abk, 'set');
			$id = BBC::validate('int+', $id, 'set');
			
			// Passwort
			$pw1 = BBC::validate('pw', $pw1, 'set');
			if ($pw1 != $pw2)
				Message::$errorType = 'set_pw_different';

			if (!MySQL::single("SELECT COUNT(*) FROM general_settings WHERE abk = '".$abk."' AND id = '".$id."'"))
				Message::$errorType = 'unvalidForm';
			if (($abk == 'general') || ($abk == 'admin') || ($abk == 'index'))
				Message::$errorType = 'set_abk_noPermissionToDeletePage';
				
			if (Message::noError()) {
				// Dateien löschen
				unlink($abk.'.php'); // zentrale Datei löschen
				// Tabelleneinträge löschen
				MySQL::query("DELETE FROM general_settings WHERE abk = '".$abk."'");
				MySQL::query("DELETE FROM general_navigation WHERE abk = '".$abk."'");
				MySQL::query("DELETE FROM general_navigation_filenames WHERE abk = '".$abk."'");
				MySQL::query("DELETE FROM general_links WHERE abk = '".$abk."'");
				MySQL::query("DELETE FROM general_news WHERE abk = '".$abk."'");
				MySQL::query("DELETE FROM general_specialpages WHERE abk = '".$abk."'");
				MySQL::query("DELETE FROM general_temp_block WHERE abk = '".$abk."'");
				MySQL::query("DELETE FROM general_unvalid_accounts WHERE abk = '".$abk."'");
				MySQL::query("DELETE FROM general_users_pages WHERE abk = '".$abk."'");
				MySQL::query("DELETE FROM admin_rights WHERE abk = '".$abk."'");
				MySQL::query("DROP TABLE IF EXISTS
					".$abk."_account, ".$abk."_kalender, ".$abk."_gaestebuch,
					".$abk."_forum_board, ".$abk."_forum_thread, ".$abk."_forum_post");
				// Cache löschen
				$cache->clearCache('index_showPages.tpl');
				$cache->clearCache(null, $abk);
				Message::$successType = 'set_homepage_del';
				refresh(THIS.'&amp;action=newPage');
				break;
			}
			
		}
		refresh(THIS.'&amp;action=newPage');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'admin': {
		$cache->noCache('content', 'admin/adm_settings_Homepage.tpl');
		$tpl->assign('IS_FOUNDER', Admin::isFounder($edit_abk));
		$tpl->assign('ADMINS', MySQL::assocs("SELECT u.ID, u.Nick, s.FounderID FROM admin_rights AS r 
				JOIN general_users AS u ON (u.ID = r.AdminID)
				JOIN general_settings AS s ON (s.abk = r.abk)  
			WHERE r.abk = '".$edit_abk."'"));
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'admin_add': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif ((!isset($_POST['abk'], $_POST['nick'])) or 
				($edit_abk != trim($_POST['abk'])) or
				(!Admin::isFounder($edit_abk))) 
			Message::$errorType = 'unvalidForm';
		elseif (('' == $nick = trim($_POST['nick'])) or
				('neuer Admin' == $nick))
			Message::$errorType = 'unfilledForm';
		else {
			
			$nick = BBC::validate('nick', $nick);
			$user = new User(null, $nick);
			if (!$user->validate())
				Message::$errorType = 'user_notExists';
			else {
				if (Admin::isAdmin($edit_abk, $user->getID()))
					Message::$errorType = 'user_alreadyAdmin';
			}
			
			if (Message::noError()) {
				MySQL::insert("INSERT INTO admin_rights (AdminID, abk) VALUES ('".$user->getID()."', '".$edit_abk."')");
				Message::$successType = 'admin_add';
				refresh(THIS.'&amp;action=admin&amp;abk='.$edit_abk);
				break;
			}
			
		}
		refresh(THIS.'&amp;action=admin&amp;abk='.$edit_abk);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'admin_del': {
		if ($_SERVER['REQUEST_METHOD'] != 'GET') 
			Message::$errorType = 'unvalidRequest';
		elseif ((!isset($_GET['abk'], $_GET['id'])) or 
				($edit_abk != trim($_GET['abk'])) or
				('' == $id = trim($_GET['id'])) or
				(($user = new User($id)) && !$user->validate()) or 
				(!Admin::isAdmin($edit_abk, $id)) or 
				((!Admin::isFounder($edit_abk)) && ($id != NICKID)) or
				(Admin::isFounder($edit_abk, $id))) 
			Message::$errorType = 'unvalidForm';
		else {			
			if (Message::noError()) {
				MySQL::query("DELETE FROM admin_rights WHERE AdminID = '".$id."' AND abk = '".$edit_abk."'");
				Message::$successType = 'admin_del';
				refresh(THIS.'&amp;action=admin&amp;abk='.$edit_abk);
				break;
			}
			
		}
		refresh(THIS.'&amp;action=admin&amp;abk='.$edit_abk);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'editSetting': {
		// Allgemeine Einstellungen
		$tpl->assign('ACTIVATEPROFIL', Settings::is_profilActivated($edit_abk));
		$tpl->assign('SETTING', Settings::getALL($edit_abk));
		
		// Verschiedene Designs zur Auswahl
		$tpl->assign('DESIGNS', MySQL::assocs("SELECT type FROM general_designs"));
		
		// Navigationsmöglichkeiten laden
		$tpl->assign('NAV_WITHOUT_LOGIN', MySQL::assocs("SELECT section, name FROM general_navigation 
			WHERE ".Admin::validStdPage0_WHERE()));
		$tpl->assign('NAV_WITH_LOGIN', MySQL::assocs("SELECT section, name FROM general_navigation 
			WHERE ".Admin::validStdPage1_WHERE()));
		$cache->noCache('content', 'admin/adm_settings_Setting.tpl');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'set_indb': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'], $_POST['title'], $_POST['Keywords'], $_POST['design'], $_POST['absender'], 
			$_POST['std_page0'], $_POST['std_page1'], $_POST['RegistrationKey'], $_POST['Beschreibung'],
			$_POST['responsiblePerson'])) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or 
				('' == $title = trim($_POST['title'])) or 
				// Keywords
				('' == $design = trim($_POST['design'])) or 
				('' == $absender = trim($_POST['absender'])) or 
				('' == $std_page0 = trim($_POST['std_page0'])) or 
				('' == $std_page1 = trim($_POST['std_page1'])) or 
				('' == $beschreibung = trim($_POST['Beschreibung'])) or 
				('' == $responsiblePerson = trim($_POST['responsiblePerson'])))
			Message::$errorType = 'unfilledForm';
		else {
			// beachte KalenderBoardID und ActivateRegistration showAll steht nicht immer in Post (Checkbuttons, kein Board)
			
			$title = Admin::validate('title', $title, 'set_hp');
			$keywords = Admin::validate('keywords', $_POST['Keywords'], 'set'); 
			$design = Admin::validate('design', $design, 'set');
			$absender = BBC::validate('mail', $absender, 'set');
			$responsiblePerson = Admin::validate('BBC 500', $responsiblePerson, 'set_resPerson');
			
			// Standardseite
			if (!MySQL::single("SELECT COUNT(*) FROM general_navigation 
				WHERE section = '".$std_page0."' AND ".Admin::validStdPage0_WHERE()))
				Message::$errorType = 'set_Stdpage0_unvalid';
			if (!MySQL::single("SELECT COUNT(*) FROM general_navigation 
				WHERE section = '".$std_page1."' AND ".Admin::validStdPage1_WHERE()))
				Message::$errorType = 'set_Stdpage1_unvalid';
			// Registierung aktivieren
			$ActivateRegistration = 0;
			if (isset($_POST['ActivateRegistration']) && $_POST['ActivateRegistration'] == 1) {
				$ActivateRegistration = 1;
			}
			// Registierungs-Key
			$RegistrationKey = BBC::validate('string 30', $_POST['RegistrationKey'], 'set_regKey');
			// Allen anzeigen (showAll)
			$showAll = 0;
			if (isset($_POST['showAll']) && $_POST['showAll'] == 1) {
				$showAll = 1;
			}
			$beschreibung = BBC::validate('string 500', $beschreibung, 'set_beschreibung');
			
			// Profile aktivieren
			$activateProfil = 0;
			if (isset($_POST['activateProfil']) && $_POST['activateProfil'] == 1) {
				$activateProfil = 1;
			}
			// Bilderupload (Header)
			if (Message::noError() && $_FILES['headerFile']['tmp_name'] != '') {
				$datei = GetImageSize($_FILES['headerFile']['tmp_name']);
				if($datei[2] != 1 && $datei[2] != 2 && $datei[2] != 3)
					Message::$errorType = 'set_header_unvalidType';
				else {
					if(204800 < $_FILES['headerFile']['size']) 
						Message::$errorType = 'set_header_unvalidSize1';
					else {
						if (800 < $datei[0] || 200 < $datei[1])
							Message::$errorType = 'set_header_unvalidSize2';
						else {
							$types = array(1 => '.gif', 2 => '.jpg', 3 => '.png');
							$pic_header = 'header'.$types[$datei[2]];
							move_uploaded_file($_FILES['headerFile']['tmp_name'], DATA.'pics_page/'.$edit_abk.'_'.$pic_header);
						}
					}
				}
			}
			// Bilderupload (Favicon)
			if (Message::noError() && $_FILES['faviconFile']['tmp_name'] != '') {
				$typ = $_FILES['faviconFile']['type'];
				if ($typ != 'image/ico' && $typ != 'image/x-icon')
					Message::$errorType = 'set_favicon_unvalidType';
				else {
					if(5120 < $_FILES['faviconFile']['size']) 
						Message::$errorType = 'set_favicon_unvalidSize';
					else {
						$shortcut_icon = '_favicon.ico';
						move_uploaded_file($_FILES['faviconFile']['tmp_name'], DATA.'pics_page/'.$edit_abk.'_'.$shortcut_icon);
					}
				}
			}
			unset($datei, $typ, $types);
			if (Message::noError()) {
				$cache->clearCache('header.tpl', $edit_abk);
				$cache->clearCache('all_login.tpl', $edit_abk);
				$cache->clearCache('all_specialpages.tpl', $edit_abk);
				$cache->clearCache('index_showPages.tpl');
				MySQL::query("UPDATE general_settings 
					SET title = '".$title."',
						Keywords = '".$keywords."', ".
						(isset($shortcut_icon) ? "shortcut_icon = '".$shortcut_icon."', " : "").
						(isset($pic_header) ? "pic_header = '".$pic_header."', " : "").
						"design_type = '".$design."',
						absender = '".$absender."',
						std_page0 = '".$std_page0."',
						std_page1 = '".$std_page1."',
						ActivateRegistration = '".$ActivateRegistration."',
						RegistrationKey = '".$RegistrationKey."',
						showAll = '".$showAll."',
						Beschreibung = '".$beschreibung."',
						responsiblePerson = '".$responsiblePerson."'
					WHERE abk = '".$edit_abk."'"); 
				if ((!Settings::is_profilActivated($edit_abk)) && $activateProfil) {
					MySQL::query("CREATE TABLE `".$edit_abk."_account` (
						`ID` int(10) UNSIGNED NOT NULL auto_increment,
						`Letzter_Login` int(11) NOT NULL DEFAULT '0',
						`Aktivitaet` int(11) NOT NULL DEFAULT '0',
						`ICQ` varchar(9) NOT NULL DEFAULT '0',
						`Skype` varchar(30) NOT NULL DEFAULT '',
						`EMail_show` tinyint(1) NOT NULL DEFAULT '1',
						`Benachrichtigung` tinyint(1) DEFAULT '1',
						`Geburtstag` int(11) NOT NULL DEFAULT '0',
						`ForumPostCounter` int(10) UNSIGNED NOT NULL DEFAULT '0',
						PRIMARY KEY  (`ID`)
						);");
					// Dummy erstellen
					$id = MySQL::insert("INSERT INTO ".$edit_abk."_account VALUES ()");
					MySQL::query("UPDATE ".$edit_abk."_account SET ID = '".DUMMYID."' WHERE ID = '".$id."'");
					if (User::getNumberOfUsers($edit_abk)) {
						$users = MySQL::assocs("SELECT u.ID FROM general_users AS u 
								JOIN general_users_pages AS p ON (p.ID = u.ID) 
							WHERE p.abk = '".$edit_abk."'");
						$temp = "INSERT INTO ".$edit_abk."_account (ID) VALUES ";
						$i = 0;
						foreach($users as $vl) {
							if ($i) { $temp .= ','; }
							$i++;
							$temp .= " ('".$vl['ID']."')";
						}
						MySQL::query($temp);
					}
				} elseif (Settings::is_profilActivated($edit_abk) && (!$activateProfil)) {
					MySQL::query("DROP TABLE `".$edit_abk."_account`");
				}
				Message::$successType = 'set_edit';
				refresh(THIS.'&amp;action=editSetting&amp;abk='.$edit_abk);
				break;
			}
		}
		refresh(THIS.'&amp;action=editSetting&amp;abk='.$edit_abk);
		
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'editNav': {
		// Navigation auslesen
		$nav = MySQL::assocs("SELECT ID, abk, declared, showInNav, section, orderID, name, title FROM general_navigation 
			WHERE (abk = '".$edit_abk."') ORDER BY OrderID");
		$nav_output = array();
		foreach($nav AS $vl) {
			if ($vl['section'] == 'redirect' || $vl['section'] == 'redirect_int')
				$vl['href'] = MySQL::single("SELECT link FROM general_links WHERE ID = '".$vl['ID']."'"); 
			array_push($nav_output, $vl);
		}
		$specialpages = MySQL::assocs("SELECT section, Titel FROM general_specialpages WHERE abk = '".$edit_abk."'");
		$tpl->assign('SPECIALPAGES', $specialpages);
		$tpl->assign('NAVIGATION', $nav_output); unset($nav, $nav_output);
		$tpl->assign('FILENAMES', MySQL::assocs("SELECT filename FROM general_navigation_filenames WHERE abk = '".$edit_abk."'"));
		$cache->noCache('content', 'admin/adm_settings_Nav.tpl');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'nav_indb': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'], $_POST['ID'], $_POST['name'], 
						$_POST['title'], $_POST['orderID'])) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or 
				(0 == $id = trim($_POST['ID'])) or
				('' == $name = trim($_POST['name'])) or 
				('' == $orderID = trim($_POST['orderID'])))
			Message::$errorType = 'unfilledForm';
		else {
			// beachte declared und showInNav steht nicht immer in Post (Checkbuttons, kein Board)
			
			$id = BBC::validate('int+', $id, 'nav_id');
			if (Message::noError()) {
				$temp_menu = MySQL::assoc("SELECT abk, section, filename FROM general_navigation WHERE id = '".$id."'");
				if ($temp_menu['abk'] != $edit_abk)
					Message::$errorType = 'unvalidRequest';
				$name = Admin::validate('title', $name, 'nav');
					
				$orderID = BBC::validate('int', $orderID, 'nav_orderID');
				$title = BBC::validate('string 500', $_POST['title'], 'nav_besch');
			}
			
			// Link
			if (isset($_POST['href']) AND $temp_menu['section'] == 'redirect' OR $temp_menu['section'] == 'redirect_int') {
				$href = Admin::validate('href 500', $_POST['href'], 'nav');
			}
			// Login nötig
			$declared = 0;
			if ((isset($_POST['declared']) && $_POST['declared'] == 1) || 
				(in_array($temp_menu['section'], array('forum', 'kalender', 'start', 'logout', 'upload')))) {
				$declared = 1;
			}
			// In Navigation anzeigen
			$showInNav = 0;
			if (isset($_POST['showInNav']) && $_POST['showInNav'] == 1) {
				$showInNav = 1;
			}

			if (Message::noError()) {
				if ($edit_abk == 'general') {
					$cache->clearCache('menu.tpl');
					$cache->clearCache('footer.tpl');
				} else {
					$cache->clearCache('menu.tpl', $edit_abk);
					$cache->clearCache('footer.tpl', $edit_abk);
				}
				MySQL::query("UPDATE general_navigation
					SET declared = '".$declared."',
						showInNav = '".$showInNav."',
						orderID = '".$orderID."',
						name = '".$name."',
						title = '".$title."'
					WHERE id = '".$id."' AND abk = '".$edit_abk."'");
				if (isset($href))
					MySQL::query("UPDATE general_links
						SET link = '".$href."'
						WHERE ID = '".$id."' AND abk = '".$edit_abk."'");
				Message::$successType = 'nav_edit';
				refresh(THIS.'&amp;action=editNav&amp;abk='.$edit_abk);
				break;
			}
		}
		refresh(THIS.'&amp;action=editNav&amp;abk='.$edit_abk);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'nav_add': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'], $_POST['type'], $_POST['name'], 
						$_POST['href'], $_POST['title'], $_POST['orderID'])) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or 
				('' == $type = trim($_POST['type'])) or
				('' == $name = trim($_POST['name'])) or 
				('' == $orderID = trim($_POST['orderID'])))
			Message::$errorType = 'unfilledForm';
		else {
			// beachte declared und showInNav steht nicht immer in Post (Checkbuttons, kein Board)
			
			// Typ
			$type = Admin::validate('type', $type, 'nav');
			if ($type != 'userDefined')
				$filename = 'all_'.$type.'.php';
			else {
				if ((!isset($_POST['filename'])) ||
					('' == $filename = addslashes($_POST['filename'])) ||
					(!MySQL::single("SELECT COUNT(*) FROM general_navigation_filenames 
						WHERE abk = '".$edit_abk."' AND filename = '".addslashes($_POST['filename'])."'")))
					Message::$errorType = 'nav_filename_unvalid';
			}
			
			// Login nötig
			$declared = 0;
			if ((isset($_POST['declared']) && $_POST['declared'] == 1) || 
				(in_array($type, array('forum', 'kalender', 'start', 'logout', 'upload')))) {
				$declared = 1;
			}
			// section
			$section = 'error';
			if ($type != 'specialpages' && $type != 'userDefined') 
				$section = $type;
			elseif ($type == 'userDefined') {
				if (isset($filename))
					$section = MySQL::single("SELECT section FROM general_navigation_filenames
						WHERE abk = '".$edit_abk."' AND filename = '".$filename."'");
			}
			elseif (isset($_POST['edit_section'])) {
				$section = Admin::validate('section', $_POST['edit_section'], 'nav');
				if (!Admin::validNavSectionSP($section, $edit_abk)) 
					Message::$errorType = 'nav_section_unvalidSP';
				if (Admin::validNavSectionUsed($section, $edit_abk, $declared))
					Message::$errorType = 'nav_section_unvalidDouble';
			}
			else Message::$errorType = 'nav_section_unvalid'; 
			
			// Link
			if ($type == 'redirect' OR $type == 'redirect_int') {
				$href = Admin::validate('href 500', $_POST['href'], 'nav');
			}
			$name = Admin::validate('title', $name, 'nav');
			$orderID = BBC::validate('int', $orderID, 'nav_orderID');
			$title = BBC::validate('string 500', $_POST['title'],'nav_besch');
			// In Navigation anzeigen
			$showInNav = 0;
			if (isset($_POST['showInNav']) && $_POST['showInNav'] == 1) {
				$showInNav = 1;
			}

			if (Message::noError()) {
				if ($edit_abk == 'general') {
					$cache->clearCache('menu.tpl');
					$cache->clearCache('footer.tpl');
				} else {
					$cache->clearCache('menu.tpl', $edit_abk);
					$cache->clearCache('footer.tpl', $edit_abk);
				}
				MySQL::query("INSERT INTO general_navigation
					(abk, declared, showInNav, section, orderID, name, title, filename)
					VALUES ('".$edit_abk."', '".$declared."', '".$showInNav."', '".$section."', '".$orderID."',
							'".$name."', '".$title."', '".$filename."')");
				if (isset($href)) {
					$id = MySQL::single("SELECT ID FROM general_navigation ORDER BY ID DESC LIMIT 1");
					MySQL::query("INSERT INTO general_links (ID, abk, link)
						VALUES ('".$id."', '".$edit_abk."', '".$href."')");
				}
				Message::$successType = 'nav_create';
				refresh(THIS.'&amp;action=editNav&amp;abk='.$edit_abk);
				break;
			}
		}
		refresh(THIS.'&amp;action=editNav&amp;abk='.$edit_abk);
		break;
	}	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'nav_del': {
		if (isset($_GET['id']) && is_numeric($_GET['id'])) {
			$id = $_GET['id'];
			if (MySQL::single("SELECT COUNT(*) FROM general_navigation 
				WHERE id = '".$id."' AND abk = '".$edit_abk."'")) {
				$section = MySQL::single("SELECT section FROM general_navigation WHERE id = '".$id."'");
				if ($section == 'redirect' || $section == 'redirect_int') {
					MySQL::query("DELETE FROM general_links WHERE ID = '".$id."'");
				}
				MySQL::query("DELETE FROM general_navigation WHERE ID = '".$id."'");
				if ($edit_abk == 'general') {
					$cache->clearCache('menu.tpl');
				} else {
					$cache->clearCache('menu.tpl', $edit_abk);
				}
				Message::$successType = 'nav_del';
				refresh(THIS.'&amp;action=editNav&amp;abk='.$edit_abk);
				break;
			}
		}
		Message::$errorType = 'nav_deleteNotOwn';
		refresh(THIS.'&amp;action=editNav&amp;abk='.$edit_abk);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_activate': {		
		$temp = Settings::is_ForumActivated($edit_abk);
		$tpl->assign('KEIN_FORUM', !$temp);
		if ($temp) {
			$foren = MySQL::assocs("SELECT BoardID, Name, OrderID, Description FROM ".$edit_abk."_forum_board");
			$tpl->assign('FOREN', $foren);
		}
		$cache->noCache('content', 'admin/adm_settings_Board.tpl');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_add': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif ((!isset($_POST['abk'], $_POST['name'])) &&
				(Settings::is_ForumActivated($edit_abk))) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or 
				('' == $name = trim($_POST['name'])))
			Message::$errorType = 'unfilledForm';
		else {
			$name = BBC::validate('name', $name, 'board');
			
			if (Message::noError()) {
				$cache->clearCache('all_forum.tpl', $edit_abk.'|index');
				MySQL::query("INSERT INTO ".$edit_abk."_forum_board
					(Name) VALUES ('".$name."')");
				Message::$successType = 'board_board_create';
				refresh(THIS.'&amp;action=board_activate&amp;abk='.$edit_abk);
				break;
			}
		}
		refresh(THIS.'&amp;action=board_activate&amp;abk='.$edit_abk);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_del': {
		if ((isset($_GET['id']) && is_numeric($_GET['id'])) &&
			(Settings::is_ForumActivated($edit_abk))) {
			$id = $_GET['id'];
			if (MySQL::single("SELECT COUNT(*) FROM ".$edit_abk."_forum_board
				WHERE BoardID = '".$id."'")) {
				$cache->clearCache('all_forum.tpl', $edit_abk.'|index');
				MySQL::query("DELETE FROM ".$edit_abk."_forum_board WHERE BoardID = ".$id);
				Message::$successType = 'board_board_del';
				refresh(THIS.'&amp;action=board_activate&amp;abk='.$edit_abk);
				break;
			}
		}
		Message::$errorType = 'board_DeleteNotOwn';
		refresh(THIS.'&amp;action=board_activate&amp;abk='.$edit_abk);
		break;
	}	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_truncate': {
		if ((isset($_GET['id']) && is_numeric($_GET['id'])) &&
			(Settings::is_ForumActivated($edit_abk))) {
			$id = $_GET['id'];
			if (MySQL::single("SELECT COUNT(*) FROM ".$edit_abk."_forum_board
				WHERE BoardID = '".$id."'")) {
				$cache->clearCache('all_forum.tpl', $edit_abk.'|index');
				MySQL::query("DELETE p FROM ".$edit_abk."_forum_post AS p 
					JOIN ".$edit_abk."_forum_thread AS t ON (t.ThreadID = p.ThreadID)
					WHERE t.BoardID = '".$id."'");
				MySQL::query("DELETE FROM ".$edit_abk."_forum_thread WHERE BoardID = '".$id."'");
				MySQL::query("UPDATE ".$edit_abk."_forum_board SET
					Posts = 0, Threads = 0, LastPostID = 0 WHERE BoardID = '".$id."'");
				Message::$successType = 'board_board_truncate';
				refresh(THIS.'&amp;action=board_activate&amp;abk='.$edit_abk);
				break;
			}
		}
		Message::$errorType = 'board_TruncateNotOwn';
		refresh(THIS.'&amp;action=board_activate&amp;abk='.$edit_abk);
		break;
	}	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_indb': {
		if (isset($_GET['add']) && 
			($_GET['add'] == 1) && 
			(!Settings::is_ForumActivated($edit_abk))) {
			$cache->clearCache('all_forum.tpl', $edit_abk);
			MySQL::query("CREATE TABLE `".$edit_abk."_forum_board` (
			  `BoardID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			  `Name` varchar(127) NOT NULL DEFAULT 'Neues Forum',
			  `OrderID` int(11) NOT NULL DEFAULT '0',
			  `Description` varchar(255) NOT NULL DEFAULT '',
			  `Posts` int(11) NOT NULL DEFAULT '0',
			  `Threads` int(11) NOT NULL DEFAULT '0',
			  `LastPostID` int(10) UNSIGNED NOT NULL DEFAULT '0',
			  PRIMARY KEY (`BoardID`)
			);");
			MySQL::query("INSERT INTO `".$edit_abk."_forum_board` (Name, Description) 
				VALUES ('Erstes Forum', 'Das ist dein erstes Forum')");
			MySQL::query("CREATE TABLE `".$edit_abk."_forum_thread` (
			  `ThreadID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			  `BoardID` int(10) UNSIGNED NOT NULL DEFAULT '0',
			  `Thema` varchar(100) NOT NULL DEFAULT 'Neues Thema',
			  `Autor` varchar(20) NOT NULL DEFAULT '',
			  `AutorID` int(10) UNSIGNED NOT NULL DEFAULT '0',
			  `LastPostID` int(10) UNSIGNED NOT NULL DEFAULT '0',
			  `Posts` int(11) NOT NULL DEFAULT '0',
			  PRIMARY KEY (`ThreadID`)
			);");
			MySQL::query("CREATE TABLE `".$edit_abk."_forum_post` (
			  `PostID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			  `ThreadID` int(10) UNSIGNED NOT NULL DEFAULT '0',
			  `Autor` varchar(20) NOT NULL DEFAULT '',
			  `AutorID` int(10) UNSIGNED NOT NULL DEFAULT '0',
			  `Time` int(11) NOT NULL DEFAULT '0',
			  `Inhalt` text NOT NULL,
			  PRIMARY KEY (`PostID`)
			);");
			Message::$successType = 'board_create';
			refresh(THIS.'&amp;action=board_activate&amp;abk='.$edit_abk);
			break;
		}
		elseif (isset($_GET['del']) && 
			($_GET['del'] == 1) && 
			(Settings::is_ForumActivated($edit_abk))) {
			$cache->clearCache('all_forum.tpl', $edit_abk);
			MySQL::query("DROP TABLE ".$edit_abk."_forum_board");
			MySQL::query("DROP TABLE ".$edit_abk."_forum_thread");
			MySQL::query("DROP TABLE ".$edit_abk."_forum_post");
			Message::$successType = 'board_del';
			refresh(THIS.'&amp;action=editBoard&amp;abk='.$edit_abk);
			break;
		}
		// Board editieren
		elseif ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'], $_POST['Name'])) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or
				('' == $id = trim($_POST['BoardID'])) or 
				('' == $name = trim($_POST['Name'])) or
				('' == $orderID = trim($_POST['OrderID'])))
			Message::$errorType = 'unfilledForm';
		else {
			$id = BBC::validate('int+', $id, 'board_BoardID');
			$name = BBC::validate('name', $name, 'board');
			$description = BBC::validate('string 500', trim($_POST['Description'], 'board_besch'));
			$orderID = BBC::validate('int', $orderID, 'board_OrderID');
			
			if (Message::noError()) {
				$cache->clearCache('all_forum.tpl', $edit_abk.'|index');
				MySQL::query("UPDATE ".$edit_abk."_forum_board SET
					Name = '".$name."', 
					OrderID = '".$orderID."',
					Description = '".$description."'
					WHERE BoardID = '".$id."'");
				Message::$successType = 'board_board_edit';
				refresh(THIS.'&amp;action=board_activate&amp;abk='.$edit_abk);
				break;
			}
		}
		refresh(THIS.'&amp;action=board_activate&amp;abk='.$edit_abk);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_update': {
		// TODO nur wenn Board existiert
		// Die Postanzahl und die LastPostID je Thema aktualisieren
		MySQL::query("UPDATE ".$edit_abk."_forum_thread SET 
			Posts = COALESCE((SELECT COUNT(*) FROM ".$edit_abk."_forum_post
				WHERE ".$edit_abk."_forum_post.ThreadID = ".$edit_abk."_forum_thread.ThreadID),0),
			LastPostID = COALESCE((SELECT PostID FROM ".$edit_abk."_forum_post 
				WHERE ".$edit_abk."_forum_post.ThreadID = ".$edit_abk."_forum_thread.ThreadID ORDER BY TIME DESC LIMIT 1),0)");
		
		// Die Threads, Posts, LastPostID je Forum aktualisieren
		MySQL::query("UPDATE ".$edit_abk."_forum_board SET 
			Threads = COALESCE((SELECT COUNT(*) FROM ".$edit_abk."_forum_thread
				WHERE ".$edit_abk."_forum_thread.BoardID = ".$edit_abk."_forum_board.BoardID),0),
			Posts = COALESCE((SELECT SUM(Posts) FROM ".$edit_abk."_forum_thread
				WHERE ".$edit_abk."_forum_thread.BoardID = ".$edit_abk."_forum_board.BoardID),0),
			LastPostID = COALESCE((SELECT PostID FROM ".$edit_abk."_forum_post
				LEFT JOIN ".$edit_abk."_forum_thread ON (".$edit_abk."_forum_thread.ThreadID = ".$edit_abk."_forum_post.ThreadID)
					WHERE ".$edit_abk."_forum_thread.BoardID = ".$edit_abk."_forum_board.BoardID ORDER BY TIME DESC LIMIT 1),0)");
		
		if (Settings::is_profilActivated($edit_abk)) {
			MySQL::query("UPDATE ".$edit_abk."_account AS a SET
				a.ForumPostCounter = COALESCE((SELECT COUNT(*) FROM ".$edit_abk."_forum_post WHERE AutorID = a.ID),0)");
		}
		$cache->clearCache('all_forum.tpl', $edit_abk);
		
		Message::$successType = 'board_updated';
		refresh(THIS.'&amp;action=board_activate&amp;abk='.$edit_abk);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'editKalender': {
		$temp = Settings::is_KalenderActivated($edit_abk);
		$tpl->assign('KEIN_KALENDER', !$temp); 
		if ($temp) {
			// Allgemeine Einstellungen
			$tpl->assign('SETTING', MySQL::assoc("SELECT KalenderBoardID FROM general_settings WHERE abk = '".$edit_abk."'"));
			
			// Forum nachladen, falls vorhanden
			$board = array();
			if (Settings::is_ForumActivated($edit_abk)) {
				$board = MySQL::assocs("SELECT BoardID, Name FROM ".$edit_abk."_forum_board");
			}
			$tpl->assign('FORUM_BOARD', $board); unset($board);
		}
		unset($temp);
		$cache->noCache('content', 'admin/adm_settings_Kalender.tpl');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'kal_indb': {
		// Kalender aktivieren
		if (isset($_GET['add']) && 
			($_GET['add'] == 1) && 
			(!Settings::is_KalenderActivated($edit_abk))) {
			MySQL::query("CREATE TABLE `".$edit_abk."_kalender_termine` (
			  `TerminID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			  `Datum` int(11) NOT NULL DEFAULT '0',
			  `Timestamp` int(11) NOT NULL DEFAULT '0',
			  `AutorID` int(10) UNSIGNED NOT NULL DEFAULT '0',
			  `Autor` varchar(30) NOT NULL,
			  `Titel` varchar(70) NOT NULL DEFAULT '0',
			  `Beschreibung` text NOT NULL,
			  `Status` int(2) NOT NULL DEFAULT '0',
			  `ThreadID` int(10) UNSIGNED NOT NULL DEFAULT '0',
			  PRIMARY KEY (`TerminID`)
			);");
			$cache->clearCache('all_kalender.tpl', $edit_abk);
			Message::$successType = 'kal_create';
			refresh(THIS.'&amp;action=editKalender&amp;abk='.$edit_abk);
			break;
		}
		// Kalender l�schen
		elseif (isset($_GET['del']) && 
			($_GET['del'] == 1) && 
			(Settings::is_KalenderActivated($edit_abk))) {
			$cache->clearCache('all_kalender.tpl', $edit_abk);
			MySQL::query("DROP TABLE `".$edit_abk."_kalender_termine`");
			Message::$successType = 'kal_del';
			refresh(THIS.'&amp;action=editKalender&amp;abk='.$edit_abk);
			break;
		// Kalender editieren
		} elseif ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif ((!isset($_POST['abk'])) &&
				Settings::is_ForumActivated($edit_abk)) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])))
			Message::$errorType = 'unfilledForm';
		else {
			// beachte KalenderBoardID steht nicht immer in Post (Checkbuttons)

			// KalenderBoardID überprüfen
			$KalenderBoardID = 0;
			if (isset($_POST['KalenderBoardID'])) {
				$KalenderBoardID = BBC::validate('int+', $_POST['KalenderBoardID'], 'kal_BoardID_unvalid');
				$forum = new Forum($edit_abk, 'BoardID', $KalenderBoardID);
				if ($forum->validateBoardID())
					Message::$errorType = 'kal_BoardID_notExists';
			}
			if (Message::noError()) {
				MySQL::query("UPDATE ".$edit_abk."_forum_thread AS t
					JOIN ".$edit_abk."_kalender_termine AS k ON (k.ThreadID = t.ThreadID)
				 	SET BoardID = '".$KalenderBoardID."'");
				MySQL::query("UPDATE general_settings 
					SET KalenderBoardID = '".$KalenderBoardID."'
					WHERE abk = '".$edit_abk."'");
				$cache->clearCache('all_kalender.tpl', $edit_abk);
				Message::$successType = 'kal_edit';
				refresh(THIS.'&amp;action=editKalender&amp;abk='.$edit_abk);
				break;
			}
		}
		refresh(THIS.'&amp;action=editKalender&amp;abk='.$edit_abk);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'editGaestebuch': {
		$temp = Settings::is_GaestebuchActivated($edit_abk);
		$tpl->assign('KEIN_GAESTEBUCH', !$temp); 
		if ($temp) {
			// Allgemeine Einstellungen
			$tpl->assign('SETTING', MySQL::assoc("SELECT GaestebuchLockForUndeclared FROM general_settings WHERE abk = '".$edit_abk."'"));
		}
		unset($temp);
		$cache->noCache('content', 'admin/adm_settings_Gaestebuch.tpl');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'gae_indb': {
		// Gästebuch aktivieren
		if (isset($_GET['add']) && 
			($_GET['add'] == 1) && 
			(!Settings::is_GaestebuchActivated($edit_abk))) {
			MySQL::query("CREATE TABLE `".$edit_abk."_gaestebuch` (
			  `PostID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
			  `Autor` varchar(20) NOT NULL,
			  `AutorID` int(11) NOT NULL,
			  `Time` int(11) NOT NULL DEFAULT '0',
			  `Inhalt` text NOT NULL,
			  PRIMARY KEY (`PostID`)
			);");
			$cache->clearCache('all_gaestebuch.tpl', $edit_abk);
			Message::$successType = 'gae_create';
			refresh(THIS.'&amp;action=editGaestebuch&amp;abk='.$edit_abk);
			break;
		}
		// Gästebuch löschen
		elseif (isset($_GET['del']) && 
			($_GET['del'] == 1) && 
			(Settings::is_GaestebuchActivated($edit_abk))) {
			MySQL::query("DROP TABLE `".$edit_abk."_gaestebuch`");
			$cache->clearCache('all_gaestebuch.tpl', $edit_abk);
			Message::$successType = 'gae_del';
			refresh(THIS.'&amp;action=editGaestebuch&amp;abk='.$edit_abk);
			break;
		// Gästebuch editieren
		} elseif ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'])) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])))
			Message::$errorType = 'unfilledForm';
		else {
			
			// Einträge für nichtangemeldete User verbieten
			$denyEntry = 0;
			if (isset($_POST['denyEntry']) && $_POST['denyEntry'] == 1) {
				$denyEntry = 1;
			}
			
			if (Message::noError()) {
				$cache->clearCache('all_gaestebuch.tpl', $edit_abk);
				MySQL::query("UPDATE general_settings 
					SET GaestebuchLockForUndeclared = '".$denyEntry."'
					WHERE abk = '".$edit_abk."'");
				Message::$successType = 'gae_edit';
				refresh(THIS.'&amp;action=editGaestebuch&amp;abk='.$edit_abk);
				break;
			}
		}
		refresh(THIS.'&amp;action=editGaestebuch&amp;abk='.$edit_abk);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'benutzerdefiniert': {
		if (Admin::isMainAdmin()) {
			$benutzerdefiniert = MySQL::assocs("SELECT * FROM general_navigation_filenames ORDER BY abk, section");
			$tpl->assign('BENUTZERDEFINIERT',$benutzerdefiniert);
			$cache->noCache('content', 'admin/adm_settings_Benutzerdefiniert.tpl');
		}
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'BenDef_add': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST' || !Admin::isMainAdmin()) 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'], $_POST['filename'], $_POST['newSection'])) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or 
				('' == $filename = trim($_POST['filename'])) or
				('' == $section = trim($_POST['newSection'])))
			Message::$errorType = 'unfilledForm';
		else {
			$filename = BBC::validate('string 100', $filename, 'BenDef');
			$section = Admin::validate('section', $section, 'BenDef');
			
			if (!is_file(PAGES.$filename))
				Message::$errorType = 'BenDef_string_not_exists';
			
			if (Message::noError()) {
				MySQL::query("INSERT INTO general_navigation_filenames
					(abk, filename, section)
					VALUES ('".$edit_abk."', '".$filename."', '".$section."')");
				Message::$successType = 'BenDef_add';
				refresh(THIS.'&amp;action=benutzerdefiniert');
				break;
			}
		}
		refresh(THIS.'&amp;action=benutzerdefiniert');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'BenDef_del': {
		if (isset($_GET['id']) && is_numeric($_GET['id'])) {
			$id = $_GET['id'];
			if (MySQL::single("SELECT COUNT(*) FROM general_navigation_filenames 
				WHERE id = '".$id."'") && Admin::isMainAdmin()) {
				MySQL::query("DELETE FROM general_navigation_filenames WHERE ID = ".$id);
				Message::$successType = 'BenDef_del';
				refresh(THIS.'&amp;action=benutzerdefiniert');
				break;
			}
		}
		Message::$errorType = 'BenDef_id_unvalid';
		refresh(THIS.'&amp;action=benutzerdefiniert');
		break;
	}	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'getSQL': {
		break;
		
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	default: {
		header('Location: '.WWW.MAIN); exit;
	}
}

?>