<?php

// Überprüfen ob die richtige Anmeldefunktion verwendet wurde
onlyAdmin();

include_once CLASSES.'class_admin.php';
include_once CLASSES.'class_pages.php';
include_once CLASSES.'class_files.php';

// Action überprüfen
if (!isset($_GET['action'])) $_GET['action'] = 'design';
$tpl->assign('_ACTION', $_GET['action']);

if (!Admin::isMainAdmin()) {
	header('Location: '.WWW.MAIN.'?section=settings'); exit;
}

// Generiert die 4 Navigation zur Seitenwahl
Admin::nav4('design');
// Überprüfen ob man für die übergebene Seite auch Rechte hat
$edit_abk = Admin::checkABK();
define('THIS', MAIN.'?section=design');
$tpl->assign('THIS', THIS);
$tpl->assign('MAIN_ADMIN', Admin::isMainAdmin()); // Auf MAIN_ADMIN-RECHTE prüfen

switch ($_GET['action']) {
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'design': {
		$pages = new Pages(10);
		$sql_limitless = "SELECT type, template_type FROM general_designs ORDER BY type";
		$designs = MySQL::assocs($sql_limitless.$pages->limit());
		$designs_output = array();
		if (count($designs)) {
			$pages->ausgabe(THIS.'&amp;action=design', $sql_limitless, 10);
			foreach($designs as $vl) {
				$vl['design'] = TOOLS.'getDesign.php?design='.$vl['type'].'&file=';
				array_push($designs_output, $vl);
			}
		}
		$tpl->assign('DESIGNS', $designs_output);
		$cache->noCache('content', 'admin/adm_settings_Design.tpl');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'design_add': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_GET['type'], $_GET['template_type']))
			Message::$errorType = 'unvalidForm';
		elseif ($_GET['type'] == '')
			Message::$errorType = 'unfilledForm';
		else {
			$type = Admin::validate('design_create', $_GET['type'], 'design');
			$template_type = addslashes($_GET['template_type']);
			if (!in_array($template_type, array('classic', 'sidebar')))
				Message::$errorType = 'design_unvalid_template';
			
			if (Message::noError()) {
				MySQL::insert("INSERT INTO general_designs (type, template_type) 
					VALUES ('".$type."', '".$template_type."')");
				mkdir(DATA.'pics_page/design/'.$type, 0777);
				Message::$successType = 'design_add';
				refresh(THIS.'&amp;action=design');
				break;
			}
		}
		refresh(THIS.'&amp;action=design');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'design_edit': {
		if (!isset($_GET['type']))
			Message::$errorType = 'design_unvalid_type';
		else {
			$type = Admin::validate('design', $_GET['type'], 'design');
			
			if (Message::noError()) {
				$tpl->assign('TYPE', $type);
				$tpl->assign('EDIT_DESIGN', 
					MySQL::assoc("SELECT * FROM general_designs 
						WHERE type = '".$type."'"));
				$tpl->assign('TOOL_DESIGN_LINK', TOOLS.'getDesign.php?design='.$type.'&file=');
				
				$pages = new Pages(10);
				$files = new Files('design', null, ABK, $type);
				$pages->ausgabe(THIS.'&amp;action=design_edit&amp;type='.$type, 
					'', $files->output($pages->limitAry(),10,true));
				
				$cache->noCache('content', 'admin/adm_settings_Design.tpl');
				break;
			}
		}
		refresh(THIS.'&amp;action=design');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'design_new_style': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_GET['color1'], $_GET['color1_aufgehellt'], $_GET['color2'],
			$_GET['color1_link'], $_GET['color2_link'], $_GET['color_nav1_normal'], 
			$_GET['color_nav1_hover'], $_GET['type']))
			Message::$errorType = 'unvalidForm';
		elseif (($_GET['color1'] == '') ||
				($_GET['color1_aufgehellt'] == '') ||
				($_GET['color2'] == '') ||
				($_GET['color1_link'] == '') ||
				($_GET['color2_link'] == '') ||
				($_GET['color_nav1_normal'] == '') ||
				($_GET['color_nav1_hover'] == ''))
			Message::$errorType = 'unfilledForm';
		else {
			$designs['color1'] = $_GET['color1'];
			$designs['color1_aufgehellt'] = $_GET['color1_aufgehellt'];
			$designs['color2'] = $_GET['color2'];
			$designs['color1_link'] = $_GET['color1_link'];
			$designs['color2_link'] = $_GET['color2_link']; 
			$designs['color_nav1_normal'] = $_GET['color_nav1_normal'];
			$designs['color_nav1_hover'] = $_GET['color_nav1_hover'];
			if (!preg_match(COLOR_REGEX, $designs['color1']) ||
				!preg_match(COLOR_REGEX, $designs['color1_aufgehellt']) ||
				!preg_match(COLOR_REGEX, $designs['color2']) ||
				!preg_match(COLOR_REGEX, $designs['color1_link']) ||
				!preg_match(COLOR_REGEX, $designs['color2_link']) ||
				!preg_match(COLOR_REGEX, $designs['color_nav1_normal']) ||
				!preg_match(COLOR_REGEX, $designs['color_nav1_hover']))
				Message::$errorType = 'design_unvalid_color';
			$type = Admin::validate('design', $_GET['type'], 'design');
			
			if (Message::noError()) {
				$template = MySQL::single("SELECT template_type FROM general_designs WHERE type = '".$type."'");
				$temp_tpl = $cache->getTemplate($template);
				$temp_tpl->assign('FETCH_STYLE', $designs);
				$temp_tpl->assign('FETCH_TYPE', $type);
				$temp = $temp_tpl->caching;
				$temp_tpl->caching = false;
				$newFileData = $temp_tpl->fetch('style.tpl');
				$temp_tpl->caching = $temp;
				$fileName = DATA.'pics_page/design/'.$type.'/'.'style.css';
				setlocale(LC_TIME, 'de_DE');
				$savefile = fopen($fileName, "w");
				fwrite($savefile, $newFileData);
				fclose($savefile);
				MySQL::query("UPDATE general_designs 
					SET color1 = '".$designs['color1']."',
						color1_aufgehellt = '".$designs['color1_aufgehellt']."',
						color2 = '".$designs['color2']."',
						color1_link = '".$designs['color1_link']."',
						color2_link = '".$designs['color2_link']."',
						color_nav1_normal = '".$designs['color_nav1_normal']."',
						color_nav1_hover = '".$designs['color_nav1_hover']."'
					WHERE type = '".$type."'");
				
				Message::$successType = 'design_new_style';
				refresh(THIS.'&amp;action=design&amp;type='.$type);
			}
		}
		refresh(THIS.'&amp;action=design');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'design_del': {
		if ($_SERVER['REQUEST_METHOD'] != 'GET')
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_GET['type']))
			Message::$errorType = 'unvalidForm';
		elseif ($_GET['type'] == '')
			Message::$errorType = 'unfilledForm';
		else {
			$type = Admin::validate('design', $_GET['type'], 'design');
			
			if (Message::noError()) {
				MySQL::query("DELETE FROM general_designs WHERE type = '".$type."'");
				$dir = DATA.'pics_page/design/'.$type;
				$objects = scandir($dir);
				foreach ($objects as $object) {
					if ($object != "." && $object != "..") {
						if (filetype($dir."/".$object) == "dir") rrmdir($dir."/".$object); 
						else unlink($dir."/".$object);
					}
				}
				rmdir($dir);
				Message::$successType = 'design_del';
				refresh(THIS.'&amp;action=design');
				break;
			}
		}
		refresh(THIS.'&amp;action=design');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'design_files_add': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_GET['type']))
			Message::$errorType = 'unvalidForm';
		elseif ($_FILES['File']['tmp_name'] == '')
			Message::$errorType = 'unfilledForm';
		else {
			$type = Admin::validate('design', $_GET['type'], 'design');
			
			$file = new Files('design', null, ABK, $type);
			$file->upload(true);
			if (Message::noError()) {
				Message::$successType = 'upload_add';
				refresh(THIS.'&amp;action=design_edit&amp;type='.$type);
				break;
			}
		}
		refresh(THIS.'&amp;action=design_edit'.(isset($type) ? '&amp;type='.$type : ''));
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'design_files_del': {
		if ($_SERVER['REQUEST_METHOD'] != 'GET') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_GET['type'], $_GET['file']))
			Message::$errorType = 'unfilledForm';
		else {
			$type = Admin::validate('design', $_GET['type'], 'design');
			
			$file = new Files('design', $_GET['file'], ABK, $type);
			$file->delete(true);
			if (Message::noError()) {
				Message::$successType = 'upload_del';
				refresh(THIS.'&amp;action=design_edit&amp;type='.$type);
				break;
			}
		}
		refresh(THIS.'&amp;action=design_edit'.(isset($type) ? '&amp;type='.$type : ''));
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	default: {
		header('Location: '.WWW.MAIN); exit;
	}
}

?>