<?php

// Überprüfen ob die richtige Anmeldefunktion verwendet wurde
onlyAdmin();

include_once CLASSES.'class_mail.php';
include_once CLASSES.'class_admin.php';
include_once CLASSES.'class_pages.php';
include_once CLASSES.'class_termin.php';
include_once CLASSES.'class_forum.php';
include_once CLASSES.'class_files.php';

// Action überprüfen
if (!isset($_GET['action'])) $_GET['action'] = 'user_admin';
$tpl->assign('_ACTION', $_GET['action']);

if (!Admin::isAdmin()) {
	header('Location: '.WWW.MAIN.'?section=settings'); exit;
}

// Generiert die 4 Navigation zur Seitenwahl
Admin::nav4('admin');
// Überprüfen ob man für die übergebene Seite auch Rechte hat
$edit_abk = Admin::checkABK();
define('THIS', MAIN.'?section=admin&amp;abk='.$edit_abk);
$tpl->assign('THIS', THIS);
$tpl->assign('MAIN_ADMIN', Admin::isMainAdmin()); // Auf MAIN_ADMIN-RECHTE prüfen

switch ($_GET['action']) {
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'user_admin': {
		$pages = new Pages(20);
		$sql_limitless = "SELECT u.*".(Settings::is_profilActivated($edit_abk) ? ', a.Aktivitaet, a.Letzter_Login' : '')." FROM general_users AS u 
				JOIN general_users_pages AS p ON (p.ID = u.ID)
				".(Settings::is_profilActivated($edit_abk) ? 'JOIN '.$edit_abk.'_account AS a ON (a.ID = u.ID)' : '')."
				WHERE p.abk = '".$edit_abk."' AND u.ID != '".DUMMYID."' ";
		$user = MySQL::assocs($sql_limitless.$pages->limit());	
		$user_output = array();
		if (count($user)) {
			$pages->ausgabe(THIS.'&amp;action=user_admin', $sql_limitless, 5);
			foreach($user as $vl) {
				if (!isset($vl['Aktivitaet'])) {
					$vl['Aktivitaet'] = 0; $vl['Letzter_Login'] = 0;
				}
				array_push($user_output, $vl);
			}
		}
		$tpl->assign('USER', $user_output);
		$cache->noCache('content', 'admin/adm_settings_User.tpl');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'user_edit': {
		if ((isset($_GET['ID'])) && 
			(($user = new User($_GET['ID'])) && $user->validatePagePermission($edit_abk))) {
			if (Settings::is_profilActivated($edit_abk) || Admin::isMainAdmin()) {
				$user = MySQL::assoc("SELECT ".(Settings::is_profilActivated($edit_abk) ? 'a.*,' : 'u.ID, ')." u.Nick, u.EMail 
					FROM general_users AS u 
						JOIN general_users_pages AS p ON (p.ID = u.ID)
						".(Settings::is_profilActivated($edit_abk) ? 'JOIN '.$edit_abk.'_account AS a ON (a.ID = u.ID)' : '')."
					WHERE p.abk = '".$edit_abk."' AND u.ID = '".$_GET['ID']."'");
				$user['accountExists'] = Settings::is_profilActivated($edit_abk);
				$tpl->assign('USER', $user);
				$cache->noCache('content', 'admin/adm_settings_User.tpl');
				break;
			} else Message::$errorType = 'user_noEditRights';
		} else Message::$errorType = 'unvalidRequest';
		refresh(THIS.'&amp;action=user_admin');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'user_generate_pw': {
		if ((isset($_GET['ID'])) && 
			(($user = new User($_GET['ID'])) && $user->validatePagePermission($edit_abk))) {
			if (Admin::isMainAdmin()) {
				$PW = User::getGeneratePW();
				Mail::email_verschicken('newPW', array('[newPW]' => $PW), $user);
				MySQL::query("UPDATE general_users SET 
					PW = '".md5($PW)."'
					WHERE ID = '".addslashes($_GET['ID'])."' ");
				Message::$successType = 'user_pw_generate';
				refresh(THIS.'&amp;action=admUser');
				break;
			} else Message::$errorType = 'user_noEditRights';
		} else Message::$errorType = 'unvalidRequest';
		refresh(THIS.'&amp;action=user_admin');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'user_edit_indb': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'], $_POST['ID']) ||
			(($user = new User($_POST['ID'])) && !$user->validatePagePermission($edit_abk)))
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])))
			Message::$errorType = 'unfilledForm';
		else {
			$id = BBC::validate('int+', $_POST['ID'], 'user');
			
			if (isset($_POST['ICQ'], $_POST['Skype']) && Settings::is_profilActivated($edit_abk)) {
				$icq = BBC::validate('icq', trim($_POST['ICQ']));
				$skype = BBC::validate('skype', trim($_POST['Skype']));
			}
			
			if (Admin::isMainAdmin()) {
				if (!isset($_POST['Nick'], $_POST['EMail']))
					Message::$errorType = 'unvalidForm';
				elseif (('' == $Nick = $_POST['Nick']) ||
						('' == $EMail = $_POST['EMail']))
					Message::$errorType = 'unfilledForm';
				else {
					$Nick = BBC::validate('nick', $Nick);
					if (($Nick != $user->getNick()) &&
						($user->validateALL($Nick)))
						Message::$errorType = 'login_nick_alreadyUsed';
					$EMail = BBC::validate('mail', $EMail, 'profil');
					if (($EMail != $user->getEMail()) &&
						($user->checkMail($EMail)))
						Message::$errorType = 'login_mail_AlreadyUsed';
				}
			}
			
			if (Message::noError()) {
				if (Settings::is_profilActivated($edit_abk)) {
					MySQL::query("UPDATE ".$edit_abk."_account SET 
						ICQ = '".$icq."',
						Skype = '".$skype."' WHERE ID = '".$id."'");
				}
				if (Admin::isMainAdmin()) {
					MySQL::query("UPDATE general_users SET
						Nick = '".$Nick."',
						EMail = '".$EMail."' WHERE ID =  '".$id."'");
				}
				Message::$successType = 'user_edit';
				refresh(THIS.'&amp;action=user_admin');
				break;
			}
		}
		refresh(THIS.'&amp;action=user_admin');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'user_del': {
		$pages = new Pages(20);
		if (isset($_GET['ID']) && is_numeric($_GET['ID'])) {
			$user = new User($_GET['ID']);
			if ($user->validatePagePermission($edit_abk)) {
				$pages->getPage_User($user->getID(), $edit_abk);
				MySQL::query("DELETE FROM general_users_pages WHERE ID = '".$user->getID()."' AND abk = '".$edit_abk."'");
				if (Settings::is_profilActivated($edit_abk)) {
					MySQL::query("DELETE FROM ".$edit_abk."_account WHERE ID = '".$user->getID()."'");
				}
				Message::$successType = 'user_rights_del';
				refresh(THIS.'&amp;action=admUser&amp;page='.$pages->getPage());
				break;
			}
		}
		Message::$errorType = 'user_DelNotExists';
		refresh(THIS.'&amp;action=user_admin');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'user_del_all': {
		if ((Admin::isMainAdmin()) && 
			(isset($_GET['ID'])) && ($user = new User($_GET['ID'])) && 
			($user->getID() != NICKID) && ($user->validate()) &&
			(!Admin::isMainAdmin($user->getID()))) {
			// Profile löschen
			$abks = $user->getPages();
			foreach($abks as $abk => $vl) {
				if (Settings::is_profilActivated($abk))
					MySQL::query("DELETE FROM ".$abk."_account WHERE ID = '".$user->getID()."'");
				if (Settings::is_ForumActivated($abk)) {
					MySQL::query("UPDATE ".$abk."_forum_thread 
						SET AutorID = '".DUMMYID."' WHERE AutorID = '".$user->getID()."'");
					MySQL::query("UPDATE ".$abk."_forum_post 
						SET AutorID = '".DUMMYID."' WHERE AutorID = '".$user->getID()."'");
				}
				if (Settings::is_KalenderActivated($abk))
					MySQL::query("UPDATE ".$abk."_kalender_termine 
						SET AutorID = '".DUMMYID."' WHERE AutorID = '".$user->getID()."'");
				if (Settings::is_GaestebuchActivated($abk))
					MySQL::query("UPDATE ".$abk."_gaestebuch 
						SET AutorID = '".DUMMYID."' WHERE AutorID = '".$user->getID()."'");
			}
			unset($abks);
			// Admin und Gründerrechte übertragen
			$abks = MySQL::assocs("SELECT abk FROM general_settings WHERE FounderID = '".$user->getID()."'");
			foreach($abks as $abk => $vl) {
				MySQL::query("UPDATE general_settings SET FounderID = '".NICKID."' WHERE FounderID = '".$user->getID()."'");
				MySQL::insert("INSERT INTO admin_rights (AdminID, abk) VALUES ('".NICKID."', '".$abk."'");
			}
			// User löschen
			MySQL::query("DELETE FROM admin_rights WHERE AdminID = '".$user->getID()."'");
			MySQL::query("DELETE FROM general_users WHERE ID = '".$user->getID()."'");
			MySQL::query("DELETE FROM general_users_pages WHERE ID = '".$user->getID()."'");
			Message::$successType = 'user_del_all';
			refresh(THIS.'&amp;action=admUser');
			break;
		}
		Message::$errorType = 'user_DelNotExists';
		refresh(THIS.'&amp;action=user_admin');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'editSpecialPages': {
		include CLASSES.'class_specialpage.php';
		$tpl->assign('SPECIALPAGES', SpecialPage::getAllPages($edit_abk));
		$cache->noCache('content', 'admin/adm_settings_SpecialPages.tpl');
		break;
	}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 
	case 'spp_add': {
		include CLASSES.'class_specialpage.php';
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'], $_POST['new_section'], $_POST['Titel'])) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or 
				('' == $section = trim($_POST['new_section'])) or
				('' == $Titel = trim($_POST['Titel'])))
			Message::$errorType = 'unfilledForm';
		else {
			$sp = new SpecialPage($section, $edit_abk);
			$sp->set('new', $Titel, 'Der Inhalt folgt ...');
			if (Message::noError()) {
				refresh(THIS.'&amp;action=editSpecialPages&amp;abk='.$edit_abk);
				break;
			}
		}
		refresh(THIS.'&amp;action=editSpecialPages&amp;abk='.$edit_abk);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'spp_del': {
		include CLASSES.'class_specialpage.php';
		if (isset($_GET['edit_section'])) {
			$sp = new SpecialPage($_GET['edit_section'], $edit_abk);
			$sp->delete();
			if (Message::noError()) {
				refresh(THIS.'&amp;action=editSpecialPages&amp;abk='.$edit_abk);
				break;
			}
		}
		Message::$errorType = 'sp_deleteNotOwn';
		refresh(THIS.'&amp;action=editSpecialPages&amp;abk='.$edit_abk);
		break;
	}	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'editSpecialPage': {
		include CLASSES.'class_specialpage.php';
		if (isset($_GET['edit_section'])) {
			$sp = new SpecialPage($_GET['edit_section'], $edit_abk);
			if ($sp->pageExists()) {
				$tpl->assign('SPECIALPAGE', $sp->getPage());
				$cache->noCache('content', 'admin/adm_settings_SpecialPages.tpl');
				break;
			}
		}
		Message::$errorType = 'unvalidRequest';
		refresh(THIS.'&amp;action=editSpecialPages&amp;abk='.$edit_abk);
		break;
	}	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'spp_indb': {
		include CLASSES.'class_specialpage.php';
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif ((!isset($_POST['abk'], $_POST['edit_section'], $_POST['Titel'], $_POST['Inhalt'])) ||
				(($sp = new SpecialPage(trim($_POST['edit_section']), $edit_abk)) &&
				 (!$sp->pageExists())))
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or 
				('' == $Inhalt = trim($_POST['Inhalt'])) or
				('' == $Titel = trim($_POST['Titel'])))
			Message::$errorType = 'unfilledForm';
		else {
			$sp->set('edit', $Titel, $Inhalt);
			if (Message::noError()) {
				refresh(THIS.'&amp;action=editSpecialPages&amp;abk='.$edit_abk);
				break;
			}
		}
		refresh(THIS.'&amp;action=editSpecialPages&amp;abk='.$edit_abk);
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board': {
		if (Settings::is_ForumActivated($edit_abk)) {
			$forum = new Forum($edit_abk);
			$board = MySQL::assocs("SELECT BoardID, Name FROM ".$edit_abk."_forum_board ORDER BY OrderID");
			$board_output = array();
			if (count($board)) {
				foreach($board as $vl) {
					if (!$forum->validateBoardID()) {
						$forum->BoardID = $vl['BoardID'];
					}
					$vl['Name'] = $BBC->ausgabe($vl['Name'], false);
					array_push($board_output, $vl);
				}
			}
			$tpl->assign('BOARDS', $board_output);
			$pages = new Pages(10);
			$sql_limitless = "SELECT t.* FROM ".$edit_abk."_forum_thread AS t
				WHERE t.BoardID = '".$forum->BoardID."' ORDER BY t.LastPostID DESC ";
			$thread = MySQL::assocs($sql_limitless.$pages->limit());
			$thread_output = array();
			if (count($thread)) {
				$pages->ausgabe(THIS.'&amp;action=board&amp;BoardID='.$forum->BoardID, $sql_limitless, 3);
				foreach($thread as $vl) {
					$vl['Thema'] = $BBC->ausgabe($vl['Thema'], false);
					array_push($thread_output, $vl);
				}
			}
			$tpl->assign('THREADS', $thread_output);
			$tpl->assign('_BOARDID', $forum->BoardID);
			$cache->noCache('content', 'admin/adm_settings_Board.tpl');
		} else {
			Message::$errorType = 'board_noBoard';
			refresh(THIS);
		}
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_thread_edit': {
		if (!Settings::is_ForumActivated($edit_abk))
			Message::$errorType = 'board_noBoard';
		elseif ('POST' != $_SERVER['REQUEST_METHOD'])
			Message::$errorType = 'unvalidRequest';
		elseif ((!isset($_POST['Thema'], $_POST['ThreadID']) or
				(($forum = new Forum($edit_abk)) && !$forum->validateThreadID())))
			Message::$errorType = 'unvalidForm';
		elseif ('' == $thema = trim($_POST['Thema']))
			Message::$errorType = 'unfilledForm';
		else {
			$forum->editThread($thema);
			if (Message::noError()) {
				Message::$successType = 'board_thread_edit';
				refresh(THIS.'&amp;action=board&amp;BoardID='.$forum->BoardID);
				break;
			}
		}
		refresh(THIS.'&amp;action=board&amp;BoardID='.(isset($forum->BoardID) ? $forum->BoardID : 0));
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_thread_del': {
		if (!Settings::is_ForumActivated($edit_abk))
			Message::$errorType = 'board_noBoard';
		elseif ('GET' != $_SERVER['REQUEST_METHOD'])
			Message::$errorType = 'unvalidRequest';
		elseif (($forum = new Forum($edit_abk)) && !$forum->validateThreadID())
			Message::$errorType = 'unvalidForm';
		else {
			$forum->delThread();
			if (Message::noError()) {
				Message::$successType = 'board_thread_del';
				refresh(THIS.'&amp;action=board&amp;BoardID='.$forum->BoardID);
				break;
			}
		}
		refresh(THIS.'&amp;action=board&amp;BoardID='.(isset($forum->BoardID) ? $forum->BoardID : 0));
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_thread': {
		if (!Settings::is_ForumActivated($edit_abk))
			Message::$errorType = 'board_noBoard';
		elseif ('GET' != $_SERVER['REQUEST_METHOD'])
			Message::$errorType = 'unvalidRequest';
		elseif (($forum = new Forum($edit_abk)) && !$forum->validateThreadID())
			Message::$errorType = 'unvalidForm1';
		else {
			$pages = new Pages(20);
			$threadtitle = MySQL::single("SELECT Thema FROM ".$edit_abk."_forum_thread WHERE ThreadID = '".$forum->ThreadID."'");
			$tpl->assign('THEMENTITEL', $BBC->ausgabe($threadtitle, false));
			if ($forum->validatePostID()) {
				$_GET['page'] = $pages->getPage_Threads($forum->ThreadID, $forum->PostID, $edit_abk);
			}
			$sql_limitless = "SELECT p.PostID, p.ThreadID, p.Autor, p.AutorID, p.Time, p.Inhalt 
				FROM ".$edit_abk."_forum_post AS p
				WHERE p.ThreadID = '".$forum->ThreadID."' ORDER BY Time ";
			$posts = MySQL::assocs($sql_limitless.$pages->limit());
			$posts_output = array();
			if (count($posts)) {
				$pages->ausgabe(THIS.'&amp;action=board_thread&amp;ThreadID='.$forum->ThreadID, $sql_limitless, 4);
				foreach($posts as $vl) {
					$vl['Inhalt_prefix'] = $BBC->ausgabe($vl['Inhalt'], false);
					if (strlen($vl['Inhalt_prefix']) > 200)
					$vl['Inhalt_prefix'] = substr($vl['Inhalt_prefix'], 0, 150)." ... ".substr($vl['Inhalt_prefix'], -45);
					array_push($posts_output, $vl);
				}
			}
			$tpl->assign('POSTS', $posts_output);
			$tpl->assign('_THREADID', $forum->ThreadID);
			$cache->noCache('content', 'admin/adm_settings_Board.tpl');
			break;
		}
		refresh(THIS.'&amp;action=board&amp;BoardID='.(isset($forum->BoardID) ? $forum->BoardID : 0));
		break; 
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_post_edit': {
		if (!Settings::is_ForumActivated($edit_abk))
			Message::$errorType = 'board_noBoard';
			elseif ('GET' != $_SERVER['REQUEST_METHOD'])
			Message::$errorType = 'unvalidRequest';
		elseif ((!isset($_GET['PostID']) or
				(($forum = new Forum($edit_abk)) && !$forum->validatePostID())))
			Message::$errorType = 'unvalidForm';
		else {
			$tpl->assign('_POSTID', $forum->PostID);
			$old = MySQL::single("SELECT Inhalt FROM ".$edit_abk."_forum_post WHERE PostID = '".$forum->PostID."'");
			$tpl->assign('OLD_INHALT', $BBC->ausgabe($old, false));
			$threadtitle = MySQL::single("SELECT Thema FROM ".$edit_abk."_forum_thread WHERE ThreadID = '".$forum->ThreadID."'");
			$tpl->assign('THEMENTITEL', $BBC->ausgabe($threadtitle, false));
			$cache->noCache('content', 'admin/adm_settings_Board.tpl');
			break;
		}
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_post_edit_indb': {
		if (!Settings::is_ForumActivated($edit_abk))
			Message::$errorType = 'board_noBoard';
		elseif ('POST' != $_SERVER['REQUEST_METHOD'])
			Message::$errorType = 'unvalidRequest';
		elseif ((!isset($_POST['PostID'], $_POST['Beitrag']) or
				(($forum = new Forum($edit_abk)) && !$forum->validatePostID())))
			Message::$errorType = 'unvalidForm';
		elseif ('' == $beitrag = trim($_POST['Beitrag']))
			Message::$errorType = 'unfilledForm';
		else {
			$forum->editPost($beitrag);
			if (Message::noError()) {
				Message::$successType = 'board_post_edit';
				refresh(THIS.'&amp;action=board_thread&amp;ThreadID='.$forum->ThreadID);
			}
			break;
		}
		refresh(THIS.'&amp;action=board_thread&amp;ThreadID='.(isset($forum->ThreadID) ? $forum->ThreadID : 0));
		break;
	}	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'board_post_del': {
		if (!Settings::is_ForumActivated($edit_abk))
			Message::$errorType = 'board_noBoard';
		elseif ('GET' != $_SERVER['REQUEST_METHOD'])
			Message::$errorType = 'unvalidRequest';
		elseif ((!isset($_GET['PostID']) or
				(($forum = new Forum($edit_abk)) && !$forum->validatePostID())))
			Message::$errorType = 'unvalidForm';
		else {
			$forum->delPost();
			if ($forum->validatePostID()) {
				Message::$successType = 'board_post_del';
				refresh(THIS.'&amp;action=board_thread&amp;PostID='.$forum->PostID.'#post');
			} else {
				Message::$successType = 'board_post_del_lastPost';
				refresh(THIS.'&amp;action=board&amp;BoardID='.$forum->BoardID);
			}
			break;
		}
		refresh(THIS.'&amp;action=board_thread&amp;PostID='.$forum->PostID.'#post');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'admKalender': {
		if (Settings::is_KalenderActivated($edit_abk)) {
			$cache->noCache('content', 'admin/adm_settings_Kalender.tpl');
			$pages = new Pages(20);
			$sql_limitless = "SELECT * FROM ".$edit_abk."_kalender_termine WHERE Status != 1 ORDER BY Datum DESC ";
			$kalender = MySQL::assocs($sql_limitless.$pages->limit());	
			$kalender_output = array();
			if (count($kalender)) {
				foreach($kalender as $vl) {
					$vl['Beschreibung_prefix'] = $BBC->ausgabe($vl['Beschreibung'], false);
					if (strlen($vl['Beschreibung_prefix']) > 200)
					$vl['Beschreibung_prefix'] = substr($vl['Beschreibung_prefix'], 0, 150)." ... ".substr($vl['Beschreibung_prefix'], -45);
					array_push($kalender_output, $vl);
				}
			}
			$pages->ausgabe(THIS.'&amp;action=admKalender', $sql_limitless, 4);
			$tpl->assign('KALENDER', $kalender_output);
		} else {
			Message::$errorType = 'kal_noKalender';
			refresh(THIS);
		}
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'kalender_edit': {
		if (Settings::is_KalenderActivated($edit_abk)) {
			if ((isset($_GET['id'])) && 
				($cur_termin = new Termin($_GET['id'], array(), $edit_abk)) && 
				($cur_termin->is_TerminID())) {
				$entry = $cur_termin->getALL();
				$entry['Beschreibung'] = $BBC->ausgabe($entry['Beschreibung'], false);
				$tpl->assign('ENTRY', $entry);
				$cache->noCache('content', 'admin/adm_settings_Kalender.tpl');
			} else {
				Message::$errorType = 'unvalidRequest';
				refresh(THIS.'&amp;action=admKalender');
			}
		} else {
			Message::$errorType = 'kal_noKalender';
			refresh(THIS);
		}
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'kalender_edit_indb': {
		if (!Settings::is_KalenderActivated($edit_abk))
			Message::$errorType = 'kal_noKalender';
		elseif ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'], $_POST['id'], $_POST['Beschreibung'], $_POST['Titel']) ||
			(!($cur_termin = new Termin($_POST['id'], array(), $edit_abk))) ||
			(!$cur_termin->is_TerminID()))
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or 
				('' == $beschreibung = trim($_POST['Beschreibung'])) or 
				('' == $titel = trim($_POST['Titel'])))
			Message::$errorType = 'unfilledForm';
		else {
			$id = BBC::validate('int+', $_POST['id'], 'kal');
			$beschreibung = BBC::validate('BBC', 
				$beschreibung."\n\n [i]Dieser Eintrag wurde vom Admin am ".date('d. M Y H:i',TIME)." editiert.[/i]", 'kal');
			
			if (Message::noError()) {
				$datum = $cur_termin->get('Datum');
				$cache->clearCache('all_kalender.tpl', $edit_abk.'|'.date('Y',$datum).'|'.date('n',$datum));
				$cur_termin->set('Titel', $titel);
				$cur_termin->set('Beschreibung', $beschreibung);
				$cur_termin->add();
				$pages = new Pages(20);
				$pages->getPage_Kalender($id, $edit_abk);
				Message::$successType = 'kal_entry_edit';
				refresh(THIS.'&amp;action=admKalender&amp;page='.$pages->getPage());
				break;
			}
		}
		refresh(THIS.'&amp;action=admKalender');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'kalender_del': {
		if (!Settings::is_KalenderActivated($edit_abk)) { refresh(THIS, 'kal_noKalender'); break; }
		if (isset($_GET['id'])) {
			$cur_termin = new Termin($_GET['id'], array(), $edit_abk);
			if ($cur_termin->is_TerminID()) {
				$pages = new Pages(20);
				$pages->getPage_Kalender($cur_termin->get('TerminID'), $edit_abk);
				$datum = $cur_termin->get('Datum');
				$cache->clearCache('all_kalender.tpl', $edit_abk.'|'.date('Y',$datum).'|'.date('n',$datum));
				$cur_termin->del();
				Message::$successType = 'kal_entry_del';
				refresh(THIS.'&amp;action=admKalender&amp;page='.$pages->getPage());
				break;
			}
		}
		Message::$errorType = 'kal_DelNotExists';
		refresh(THIS.'&amp;action=admKalender');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'admGaestebuch': {
		if (Settings::is_GaestebuchActivated($edit_abk)) {
			$pages = new Pages(20);
			$sql_limitless = "SELECT * FROM ".$edit_abk."_gaestebuch ORDER BY Time DESC ";
			$gaestebuch = MySQL::assocs($sql_limitless.$pages->limit());	
			$gaestebuch_output = array();
			if (count($gaestebuch)) {
				$pages->ausgabe(THIS.'&amp;action=admGaestebuch', $sql_limitless, 3);
				foreach($gaestebuch as $vl) {
					$vl['Inhalt_prefix'] = $BBC->ausgabe($vl['Inhalt'], false);
					if (strlen($vl['Inhalt_prefix']) > 200)
					$vl['Inhalt_prefix'] = substr($vl['Inhalt_prefix'], 0, 150)." ... ".substr($vl['Inhalt_prefix'], -45);
					array_push($gaestebuch_output, $vl);
				}
			}
			$tpl->assign('GAESTEBUCH', $gaestebuch_output);
			$cache->noCache('content', 'admin/adm_settings_Gaestebuch.tpl');
		} else {
			Message::$errorType = 'gae_noGaestebuch';
			refresh(THIS);
		}
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'gaestebuch_edit': {
		if (Settings::is_GaestebuchActivated($edit_abk)) {
			if ((isset($_GET['id'])) && 
				(is_numeric($_GET['id'])) && 
				(MySQL::single("SELECT COUNT(*) FROM ".$edit_abk."_gaestebuch WHERE PostID = '".addslashes($_GET['id'])."'"))) {
				$entry = MySQL::assoc("SELECT * FROM ".$edit_abk."_gaestebuch WHERE PostID = '".$_GET['id']."'");
				$entry['Inhalt'] = $BBC->ausgabe($entry['Inhalt'], false);
				$tpl->assign('ENTRY', $entry);
				$cache->noCache('content', 'admin/adm_settings_Gaestebuch.tpl');
			} else {
				Message::$errorType = 'unvalidRequest';
				refresh(THIS.'&amp;action=admGaestebuch');
			}
		} else {
			Message::$errorType = 'gae_noGaestebuch';
			refresh(THIS);
		}
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'gaestebuch_edit_indb': {
		if (!Settings::is_GaestebuchActivated($edit_abk))
			Message::$errorType = 'gae_noGaestebuch';
		elseif ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'], $_POST['id'], $_POST['Inhalt']) ||
			(!is_numeric($_POST['id'])) ||
			(!MySQL::single("SELECT COUNT(*) FROM ".$edit_abk."_gaestebuch WHERE PostID = '".$_POST['id']."'"))) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or 
				('' == $inhalt = trim($_POST['Inhalt'])))
			Message::$errorType = 'unfilledForm';
		else {
			$id = BBC::validate('int+', $_POST['id'], 'gae');
			$inhalt = BBC::validate('BBC', 
				$inhalt."\n\n [i]Dieser Eintrag wurde vom Admin am ".date('d. M Y H:i',TIME)." editiert.[/i]", 'gae');
			
			if (Message::noError()) {
				$pages = new Pages(20);
				$pages->getPage_Gaestebuch($id, $edit_abk);
				$cache->clearCache('all_gaestebuch.tpl', $edit_abk.'|index');
				MySQL::query("UPDATE ".$edit_abk."_gaestebuch SET
					Inhalt = '".$inhalt."'
					WHERE PostID =  '".$id."'");
				Message::$successType = 'gae_entry_edit';
				refresh(THIS.'&amp;action=admGaestebuch&amp;page='.$pages->getPage());
				break;
			}
		}
		refresh(THIS.'&amp;action=admGaestebuch');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'gaestebuch_del': {
		$pages = new Pages(20);
		if (!Settings::is_GaestebuchActivated($edit_abk)) { refresh(THIS, 'noGaestebuch'); break; }
		if (isset($_GET['id']) && is_numeric($_GET['id'])) {
			$id = $_GET['id'];
			if (MySQL::single("SELECT COUNT(*) FROM ".$edit_abk."_gaestebuch WHERE PostID = '".$id."'")) {
				$pages->getPage_Gaestebuch($id, $edit_abk);
				$cache->clearCache('all_gaestebuch.tpl', $edit_abk.'|index');
				MySQL::query("DELETE FROM ".$edit_abk."_gaestebuch WHERE PostID = ".$id);
				Message::$successType = 'gae_entry_del';
				refresh(THIS.'&amp;action=admGaestebuch&amp;page='.$pages->getPage());
				break;
			}
		}
		Message::$errorType = 'gae_DelNotExists';
		refresh(THIS.'&amp;action=admGaestebuch');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'admNews': {
		$pages = new Pages(10);
		$sql_limitless = "SELECT * FROM general_news WHERE abk = '".$edit_abk."' ORDER BY Time DESC "; 
		$news = MySQL::assocs($sql_limitless.$pages->limit());
		$news_output = array();
		foreach($news as $vl) {
			array_push($news_output, $vl);
		}
		$tpl->assign('NEWS_COUNT', MySQL::single("SELECT COUNT(*) FROM general_news WHERE abk = '".$edit_abk."'"));
		$tpl->assign('NEWS', $news_output);
		$pages->ausgabe(THIS.'&amp;action=admNews', $sql_limitless);
		$cache->noCache('content', 'admin/adm_settings_News.tpl');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'news_add': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'], $_POST['Inhalt'], $_POST['Titel'])) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or 
				('' == $inhalt = trim($_POST['Inhalt'])) or
				('' == $titel = trim($_POST['Titel'])))
			Message::$errorType = 'unfilledForm';
		else {
			$titel = BBC::validate('name', $titel, 'news');
			$inhalt = BBC::validate('BBC', $inhalt, 'news');
			
			if (Message::noError()) {
				if ($edit_abk == 'general') $cache->clearCache('all_news.tpl');
				else $cache->clearCache('all_news.tpl', $edit_abk.'|index');
				MySQL::query("INSERT INTO general_news
					(abk, titel, Time, inhalt)
					VALUES ('".$edit_abk."', '".$titel."', '".TIME."', '".$inhalt."')");
				Message::$successType = 'news_add';
				refresh(THIS.'&amp;action=admNews');
				break;
			}
		}
		refresh(THIS.'&amp;action=admNews');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'news_del': {
		if (isset($_GET['id']) && is_numeric($_GET['id'])) {
			$id = $_GET['id'];
			if (MySQL::single("SELECT COUNT(*) FROM general_news 
				WHERE id = '".$id."' AND abk = '".$edit_abk."'")) {
				MySQL::query("DELETE FROM general_news WHERE ID = ".$id);
				if ($edit_abk == 'general') $cache->clearCache('all_news.tpl');
				else $cache->clearCache('all_news.tpl', $edit_abk.'|index');
				Message::$successType = 'news_del';
				refresh(THIS.'&amp;action=admNews');
				break;
			}
		}
		Message::$errorType = 'news_deleteNotOwn';
		refresh(THIS.'&amp;action=admNews');
		break;
	}	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'admOneNews': {
		if ((isset($_GET['id'])) && 
			(is_numeric($_GET['id'])) && 
			(MySQL::single("SELECT COUNT(*) FROM general_news WHERE abk = '".$edit_abk."' AND ID = '".addslashes($_GET['id'])."'"))) {
			$news = MySQL::assoc("SELECT * FROM general_news WHERE ID = '".$_GET['id']."'");
			$news['titel'] = $BBC->ausgabe($news['titel'], false);
			$news['inhalt'] = $BBC->ausgabe($news['inhalt'], false);
			$tpl->assign('NEWS', $news);
			$cache->noCache('content', 'admin/adm_settings_News.tpl');
		}
		else {
			Message::$errorType = 'unvalidRequest';
			refresh(THIS.'&amp;action=admNews');
		}
		break;
	}	
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'news_indb': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_POST['abk'], $_POST['id'], $_POST['Titel'], $_POST['Inhalt']) ||
			(!is_numeric($_POST['id'])) ||
			(!MySQL::single("SELECT COUNT(*) FROM general_news WHERE abk = '".$edit_abk."' AND id = '".$_POST['id']."'"))) 
			Message::$errorType = 'unvalidForm';
		elseif (($edit_abk != trim($_POST['abk'])) or 
				('' == $inhalt = trim($_POST['Inhalt'])) or
				('' == $titel = trim($_POST['Titel'])))
			Message::$errorType = 'unfilledForm';
		else {
			$id = $_POST['id'];
			$titel = BBC::validate('name', $titel, 'news');
			$inhalt = BBC::validate('BBC', 
				$inhalt."\n\n [i]Diese News wurde am ".date('d. M Y H:i',TIME)." editiert.[/i]", 'news');
			
			if (Message::noError()) {
				if ($edit_abk == 'general') $cache->clearCache('all_news.tpl');
				else $cache->clearCache('all_news.tpl', $edit_abk.'|index');
				MySQL::query("UPDATE general_news SET
					Titel = '".$titel."',
					Inhalt = '".$inhalt."'
					WHERE id =  '".$id."'");
				Message::$successType = 'news_edit';
				refresh(THIS.'&amp;action=admNews');
				break;
			}
		}
		refresh(THIS.'&amp;action=admNews');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'upload': {
		if ((!isset($_GET['type'])) ||
			(!Files::checkType($_GET['type']))) $type = 'public_pics';
		else $type = $_GET['type'];
		
		$pages = new Pages(10);
		
		$files = new Files($type, null, $edit_abk);
		$pages->ausgabe(THIS.'&amp;action=upload&amp;type='.$type, 
			'', $files->output($pages->limitAry(),10,true));
		
		$cache->noCache('content', 'admin/adm_settings_Upload.tpl');
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'upload_add': {
		if ($_SERVER['REQUEST_METHOD'] != 'POST') 
			Message::$errorType = 'unvalidRequest';
		elseif ($_FILES['File']['tmp_name'] == '')
			Message::$errorType = 'unfilledForm';
		else {
			if ((!isset($_GET['type'])) ||
				(!Files::checkType($_GET['type']))) $type = 'public_pics';
			else $type = $_GET['type'];
			
			$file = new Files($type, null, $edit_abk);
			$file->upload(true);
			if (Message::noError()) {
				Message::$successType = 'upload_add';
				refresh(THIS.'&amp;action=upload&amp;type='.$type);
				break;
			}
		}
		refresh(THIS.'&amp;action=upload'.(isset($type) ? '&amp;type='.$type : ''));
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	case 'upload_del': {
		if ($_SERVER['REQUEST_METHOD'] != 'GET') 
			Message::$errorType = 'unvalidRequest';
		elseif (!isset($_GET['file']))
			Message::$errorType = 'unfilledForm';
		else {
			if ((!isset($_GET['type'])) ||
				(!Files::checkType($_GET['type']))) $type = 'public_pics';
			else $type = $_GET['type'];
			
			$file = new Files($type, $_GET['file'], $edit_abk);
			$file->delete(true);
			if (Message::noError()) {
				Message::$successType = 'upload_del';
				refresh(THIS.'&amp;action=upload&amp;type='.$type);
				break;
			}
		}
		refresh(THIS.'&amp;action=upload'.(isset($type) ? '&amp;type='.$type : ''));
		break;
	}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	default: {
		header('Location: '.WWW.MAIN); exit;
	}
}

?>