<?php 

// soll ähnlich wie game.php sein

// Libs
//		Konstanten einbinden
include_once ROOTPATH.'files/lib/inc_globalvars.php';

// jegliche Error-Meldungen & Warnungen anzeigen
if (DEV) {
	error_reporting(E_ALL);
	ini_set('display_errors', 1); // die MySQL-Daten entsprechend anpassen
} else {
	error_reporting(0);
}

//		Ausgabefunktionen
include_once LIB.'inc_functions.php';
//		Datenbank-Anbindung
include_once CLASSES.'class_MySQL.php';
$mysql = new MySQL();

// Klassen
//		Einstellungen
include_once CLASSES.'class_settings.php';
Settings::add(ABK, true);
//		Sessionverwaltung
include_once CLASSES.'class_session.php';
$session = new Session();
Session::set('lastRequest', TIME);
//		Für Fehler/Erfolgs und Infomeldungen
include_once CLASSES.'class_message.php';
$message = new Message('de');
//		der Seitencache
require(LIB.'smarty/libs/Smarty.class.php');
include_once CLASSES.'class_cache.php';
$template = MySQL::single("SELECT template_type FROM general_designs 
					WHERE type = '".Settings::get(ABK, 'design_type')."'");
$cache = new Cache(Smarty::CACHING_LIFETIME_SAVED, $template, array('classic', 'sidebar'));
//      Smarty einbinden
$tpl = $cache->getABKtemplate(); /*new Smarty;
$template = TEMPLATES.
	MySQL::single("SELECT template_type FROM general_designs 
		WHERE type = '".Settings::get(ABK, 'design_type')."'").'/';
$tpl->config_dir = $template.'configs/';
//$tpl->configLoad('my.conf');
$tpl->template_dir = $template.'template/';
$tpl->compile_dir = $template.'compile/';
$tpl->cache_dir = $template.'cache/';
$tpl->addPluginsDir($template.'plugins/');
//$tpl->debugging = true; */
//		allgemeine Statistik
include_once CLASSES.'class_statistik.php';
$stats = new Statistik();
//		BBCode
include_once CLASSES.'class_BBC.php';
$BBC = new BBC();
// 		User
include_once CLASSES.'class_user.php';
//		Dateien
include_once CLASSES.'class_files.php';

if (isset($_POST['section'])) {
	$_GET = $_POST;
}

define('MAIN', ABK.'.php'); // eventuell basename() verwenden
define('DESIGN', TOOL_GETDESIGN);

// Style
//$designs = MySQL::assoc("SELECT * FROM general_designs WHERE type = '".Settings::get(ABK, 'design_type')."'");

///////////////////////////////////////////////////////////////////////////////////////////////////////
// Check ob man eingeloggt ist, falls ja wird die letzte Aktivität eingetragen

// validationcheck (verhindert fakelogin)
if (defined('DECLARED') || defined('NICKID')) die();

$user = User::validateSession();
define('NICK', $user->getNick());
define('NICKID', $user->getID());
define('DECLARED', $user->validate());
if (DECLARED) {
	$stats->addStats('ALL_WITHLOGIN');
} else {
	$stats->addStats('ALL_WITHOUTLOGIN');
}
unset($user);
// Ende des Loginchecks

///////////////////////////////////////////////////////////////////////////////////////////////////////
// Menüpunkt auf Gültigkeit überprüfen ansonsten auf die Standardseite weiterleiten
if (DECLARED) 
	$navigation2 = MySQL::assocs("SELECT abk, section, filename FROM general_navigation 
		WHERE ((abk = '".ABK."') OR abk = 'general') AND (section != 'login')");
else $navigation2 = MySQL::assocs("SELECT abk, section, filename FROM general_navigation 
	WHERE ((abk = '".ABK."' OR abk = 'general') AND declared = '0')");

if (isset($_GET['section'])) {
	foreach($navigation2 as $vl) {
		if ($_GET['section'] == $vl['section']) {
			$sideload = $vl['filename'];
			// überprüfen ob der GeneralMod mit übergeben wurde 
			if (isset($_GET['general_mod']) && ($_GET['general_mod'] == 1))  // Da GET = POST nicht extra untersucht
				$tempGENERAL_MOD = 1;
			else $tempGENERAL_MOD = 0;
			
			// Falls kein GeneralMod mit übergeben wurde nochmal überprüfen ob die Seite auch in der
			// lokalen Navigation der Seite mit drin steht.
			if (!$tempGENERAL_MOD &&
				!MySQL::single("SELECT COUNT(*) FROM general_navigation 
					WHERE abk = '".ABK."' AND section = '".$vl['section']."' ")) {
				$tempGENERAL_MOD = 1;
			}
				
			// 	Konstanten setzen
			if ($tempGENERAL_MOD) {
				define('GENERAL_ABK', 'general');
				define('GENERAL_MOD', 1);
			} else {
				define('GENERAL_ABK', ABK);
				define('GENERAL_MOD', 0);
			}
			break;
		}
	}
}
// Falls kein Menüpunkt gefunden wurde zur Standardseite weiterleiten
if (!isset($sideload)) {
	if ((isset($_GET['section'])) &&
		($_GET['section'] == Settings::get(ABK, 'std_page'.DECLARED)))
		FatalError('unvalidDefaultNav');
	header('Location: '.WWW.MAIN.'?section='.Settings::get(ABK, 'std_page'.DECLARED));
	die;
}
// Auf den richtigen Pfad wechseln
if (WWW != 'http://'.$_SERVER['HTTP_HOST'].'/') {
	header('Location: '.WWW.MAIN.'?section='.Settings::get(ABK, 'std_page'.DECLARED));
	die();
}
unset($tempGENERAL_MOD, $vl, $navigation2);
///////////////////////////////////////////////////////////////////////////////////////////////////////
// Diese stelle wird nur erreicht wenn ein gültiger Menüpunkt gewählt wurde!

// Menüpunktspezifische Aufrufe
$stats->addStats($_GET['section']);

// wichtige Assigns
$tpl->assign('NICK', NICK);
$tpl->assign('NICKID', NICKID);
$tpl->assign('DECLARED', DECLARED);
$tpl->assign('GENERAL_MOD', GENERAL_MOD);
$tpl->assign('TIME', TIME);
$tpl->assign('WWW', WWW); // Adresse (z.B. http://web714.dashosting.de)
$tpl->assign('TOOLS', TOOLS);
$tpl->assign('TOOL_GETPIC', TOOL_GETPIC);
$tpl->assign('TOOL_GETPIC_DEC', TOOL_GETPIC_DEC);
$tpl->assign('TOOL_GETPIC_GENERAL', TOOL_GETPIC_GENERAL);
$tpl->assign('TOOL_GETFILE_DEC', TOOL_GETFILE_DEC);
$tpl->assign('TOOL_GETFILE', TOOL_GETFILE);
$tpl->assign('TOOL_GETDESIGN', TOOL_GETDESIGN);
$tpl->assign('DESIGN', DESIGN);
$tpl->assign('DESIGN_TYPE', Settings::get(ABK, 'design_type'));
$tpl->assign('ABK', ABK);
$tpl->assign('MAIN', MAIN); // z.B. index.php 

if ((is_file(PAGES.$sideload)) && (file_exists(PAGES.$sideload))) {
	include PAGES.$sideload;
}


include INC.'header.php';
include INC.'menu.php';

$cache->display('header');
$cache->display('menu');
$cache->display('content');
$cache->display('footer');

unset($mysql, $session);

?>